﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace UpdaterTest
{
    [TestClass]
    public class UpdaterInCupTest
    {
        public TestContext TestContext { get; set; }
        private static bool VerifyBootImageHashes(string log)
        {
            int count = 0;
            bool same = true;
            foreach (var l in log.Split('\n'))
            {
                var trim = l.Trim();
                if (trim.StartsWith("bct") || trim.StartsWith("package1") || trim.StartsWith("package2"))
                {
                    count++;
                    var split = trim.Split('|');
                    string[] hashes = { split[1].Trim(), split[2].Trim(), split[3].Trim() };
                    if (hashes[0] != hashes[1] || hashes[0] != hashes[2])
                    {
                        same = false;
                    }
                }
            }
            if (count == 6 && same)
            {
                return true;
            }
            return false;
        }
        private static bool VerifyBootImageHashesAreCorrect(string log)
        {
            return VerifyBootImageHashes(log) == true;
        }
        private string GetSystemListFormat(UInt64 id, int version, string type)
        {
            return String.Format("0x{0,16:x16}{1,12}  {2}", id, version, type);
        }

        [ClassInitialize]
        public static void ClassInit(TestContext context)
        {
            // 通常版 BootImagePackage のみがインストールされ、それが正しく適用された状態にする
            var lib = new TestOnTargetLibrary(context);
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x0100000000000819");
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x010000000000081A");
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x010000000000081B");
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x010000000000081C");
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x010000000000B150");
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x010000000000B151");
            lib.RunDevMenuCommandSystem("systemprogram uninstall 0x010000000000B152");

            var bip = lib.GetBipPath("BootImagePackage");
            var bipsafe = lib.GetBipPath("BootImagePackageSafe");

            lib.RunDevMenuCommandSystem("systemprogram install " + bip);
            lib.RunDevMenuCommandSystem("systemprogram install " + bipsafe);

            lib.RunDevMenuCommandSystem("systemupdate update-bootimages");
            lib.RunDevMenuCommandSystem("systemupdate update-bootimages-safe");
            lib.RunDevMenuCommandSystem("systemupdate mark-verifying-required 0");
            lib.RunDevMenuCommandSystem("systemupdate mark-verifying-required-safe 0");
            lib.RunDevMenuCommandSystem("systemupdate clear-exfat-status");

            var resetHello = new RunningOptions() { WithReset = true, SuccessPattern = "Hello, world." };
            var hello = lib.GetPath("Programs/Iris/Outputs/NX-NXFP2-a64/TargetTools/HelloWorld/Develop/HelloWorld.nca");

            lib.Run(hello, "", resetHello);
        }
        [ClassCleanup]
        public static void ClassCleanup()
        {
            ClassInit(null);
        }

        [TestMethod]
        public void UpdateSequencial()
        {
            var lib = new TestOnTargetLibrary(this.TestContext);

            var resetHello = new RunningOptions() { WithReset = true, SuccessPattern = "Hello, world." };
            var hello = lib.GetPath("Programs/Iris/Outputs/NX-NXFP2-a64/TargetTools/HelloWorld/Develop/HelloWorld.nsp");
            var helloNca = lib.GetPath("Programs/Iris/Outputs/NX-NXFP2-a64/TargetTools/HelloWorld/Develop/HelloWorld.nca");

            var upp2 = lib.GetPath("Tests/Outputs/NX-NXFP2-a64/Tests/UpdaterTest/UpdatePartition/upp-v2-$KEY-$SIGNED/$BUILD/upp-v2-$KEY-$SIGNED.nsp");
            var upp3 = lib.GetPath("Tests/Outputs/NX-NXFP2-a64/Tests/UpdaterTest/UpdatePartition/upp-v3-$KEY-$SIGNED/$BUILD/upp-v3-$KEY-$SIGNED.nsp");
            var upp7 = lib.GetPath("Tests/Outputs/NX-NXFP2-a64/Tests/UpdaterTest/UpdatePartition/upp-v7-$KEY-$SIGNED/$BUILD/upp-v7-$KEY-$SIGNED.nsp");
            var upp9 = lib.GetPath("Tests/Outputs/NX-NXFP2-a64/Tests/UpdaterTest/UpdatePartition/upp-v9-$KEY-$SIGNED/$BUILD/upp-v9-$KEY-$SIGNED.nsp");

            // v2 UPP の適用
            lib.WriteToCard(hello, upp2);

            // カード再チェックのために再起動。また再起動直後は CUP 判定が正しくないので、待つ。
            lib.Run(helloNca, "", resetHello);
            System.Threading.Thread.Sleep(5000);

            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("true");
            lib.RunDevMenuCommandSystem("systemupdate do-cardupdate")
                .ExpectInLog("Done.");
            lib.RunDevMenuCommandSystem("systemupdate get-verifying-required-mark")
                .ExpectInLog("Normal: 0, Safe: 0");

            // 再起動
            lib.Run(helloNca, "", resetHello);

            // 入れたプログラムのチェック
            lib.RunDevMenuCommandSystem("systemprogram list")
                .ExpectInLog(GetSystemListFormat(0x010000000000b150, 2, "SystemUpdate"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b151, 2, "SystemProgram"));
            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("false");

            // v3 UPP の適用
            lib.WriteToCard(hello, upp3);

            // カード再チェックのために再起動。また再起動直後は CUP 判定が正しくないので、待つ。
            lib.Run(helloNca, "", resetHello);
            System.Threading.Thread.Sleep(5000);

            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("true");
            lib.RunDevMenuCommandSystem("systemupdate do-cardupdate")
                .ExpectInLog("Done.");
            lib.RunDevMenuCommandSystem("systemupdate get-verifying-required-mark")
                .ExpectInLog("Normal: 0, Safe: 0");

            // 再起動
            lib.Run(helloNca, "", resetHello);

            // 入れたプログラムのチェック
            lib.RunDevMenuCommandSystem("systemprogram list")
                .NotExpectInLog(GetSystemListFormat(0x010000000000b150, 2, "SystemUpdate"))
                .NotExpectInLog(GetSystemListFormat(0x010000000000b151, 2, "SystemProgram"))
                .NotExpectInLog(GetSystemListFormat(0x010000000000081b, 0, "BootImagePackage"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b150, 3, "SystemUpdate"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b151, 4, "SystemProgram"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b152, 5, "SystemProgram"));

            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("false");

            // exFAT が必要フラグがたっても、CUP が必要にはならない
            lib.RunDevMenuCommandSystem("systemupdate notify-exfat-required");
            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("false");

            // v7 UPP の適用 (exFAT が必要フラグがたっても、exFAT ドライバは入らないことの確認)
            lib.WriteToCard(hello, upp7);

            // カード再チェックのために再起動。また再起動直後は CUP 判定が正しくないので、待つ。
            lib.Run(helloNca, "", resetHello);
            System.Threading.Thread.Sleep(5000);

            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("true");
            lib.RunDevMenuCommandSystem("systemupdate do-cardupdate")
                .ExpectInLog("Done.");
            lib.RunDevMenuCommandSystem("systemupdate get-verifying-required-mark")
                .ExpectInLog("Normal: 0, Safe: 0");

            // 再起動
            lib.Run(helloNca, "", resetHello);

            // 入れたプログラムのチェック
            lib.RunDevMenuCommandSystem("systemprogram list")
                .NotExpectInLog(GetSystemListFormat(0x010000000000b151, 3, "SystemProgram"))
                .NotExpectInLog(GetSystemListFormat(0x010000000000081b, 0, "BootImagePackage"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b150, 7, "SystemUpdate"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b151, 4, "SystemProgram"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b152, 10, "SystemProgram"));

            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("false");

            // exFAT をダウンロード済みフラグがたっても、同じ UPP だと CUP が必要とはならない
            lib.RunDevMenuCommandSystem("systemupdate notify-exfat-downloaded");
            lib.Run(helloNca, "", resetHello);
            System.Threading.Thread.Sleep(5000);
            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("false");

            // v9 UPP の適用 (exFAT をダウンロード済みフラグの状態だと、CUP で exFAT が入ることの確認)
            lib.WriteToCard(hello, upp9);

            // カード再チェックのために再起動。また再起動直後は CUP 判定が正しくないので、待つ。
            lib.Run(helloNca, "", resetHello);
            System.Threading.Thread.Sleep(5000);

            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("true");
            lib.RunDevMenuCommandSystem("systemupdate do-cardupdate")
                .ExpectInLog("Done.");
            lib.RunDevMenuCommandSystem("systemupdate get-verifying-required-mark")
                .ExpectInLog("Normal: 0, Safe: 0");

            // 更新後の再起動
            lib.Run(helloNca, "", resetHello);

            // 入れたプログラムのチェック
            lib.RunDevMenuCommandSystem("systemprogram list")
                .NotExpectInLog(GetSystemListFormat(0x010000000000b151, 7, "SystemProgram"))
                .ExpectInLog(GetSystemListFormat(0x010000000000081b, 0, "BootImagePackage"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b150, 9, "SystemUpdate"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b151, 4, "SystemProgram"))
                .ExpectInLog(GetSystemListFormat(0x010000000000b152, 10, "SystemProgram"));
            lib.RunDevMenuCommandSystem("systemupdate check-cardupdate")
                .ExpectInLog("false");

            // exFAT 側の BootImagePackage になっているかの確認
            lib.RunDevMenuCommandSystem("systemupdate get-bootimage-package-id")
                .ExpectInLog("BootImagePackage: 010000000000081b");
            lib.RunDevMenuCommandSystem("systemupdate get-verifying-required-mark")
                .ExpectInLog("Normal: 0, Safe: 0");
            lib.RunDevMenuCommandSystem("systemupdate get-bootimage-hashes")
                .ExpectInLog(VerifyBootImageHashesAreCorrect);

        }
    }
}
