﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace UartTestHost
{
    /// <summary>
    /// テストのリザルトコードの列挙体です。
    /// </summary>
    public enum TestResult : int
    {
        /// <summary>
        /// テスト、または処理の成功。
        /// </summary>
        Success = 0,

        /// <summary>
        /// 引数が無効です。
        /// </summary>
        InvalidArg = -1,

        /// <summary>
        /// テストシナリオ値が無効です。
        /// </summary>
        InvalidTestScenario = -2,

        /// <summary>
        /// 使用可能なシリアルポートが見つかりませんでした。
        /// </summary>
        PortNotFound = -3,

        /// <summary>
        /// シリアルポートのオープンに失敗しました。
        /// 他のアプリがポートを使用している可能性があります。
        /// </summary>
        PortOpenFailed = -4,

        /// <summary>
        /// シリアルポートのクローズに失敗しました。
        /// </summary>
        PortCloseFailed = -5,

        /// <summary>
        /// シリアルポートへのデータの送信が予期せぬエラーで失敗しました。
        /// </summary>
        PortSendFailed = -6,

        /// <summary>
        /// シリアルポートからのデータの受信が予期せぬエラーで失敗しました。
        /// </summary>
        PortReceiveFailed = -7,

        /// <summary>
        /// ターゲットとのハンドシェイクに失敗しました。
        /// </summary>
        HandshakeFailed = -8,

        /// <summary>
        /// ターゲットから受信したデータに不整合が見つかりました。
        /// </summary>
        DataCorrupted = -9,

        /// <summary>
        /// ターゲットから一定時間以上応答がありませんでした。
        /// </summary>
        TargetNotResponding = -10,

        /// <summary>
        /// ターゲットから一定時間内に期待量のデータを受信できませんでした。
        /// </summary>
        DataInsufficient = -11,
    }
}
