﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;

namespace UartTestHost
{
    /// <summary>
    /// テストパラメータの構造体です。
    /// </summary>
    /// <remarks>
    /// ハンドシェイクでターゲットから受け取るデータ列を反映します。
    /// そのため、バイトオーダーは厳密にターゲット側テストプログラムの同名型と一致している必要があります。
    /// </remarks>
    [StructLayout(LayoutKind.Sequential)]
    public struct TestParam
    {
        // 暗黙のパディングが発生しないよう、TestHandshake.HandshakeWithTarget でアサートチェックをしている
        public TestScenario Scenario;
        public TestBaudRateType BaudRate;
        public TestFlowControlMode FlowControlMode;
        public byte Padding;

        public TestParam(TestScenario scenario, TestBaudRateType baudRate, TestFlowControlMode flowControlMode)
        {
            BaudRate = baudRate;
            Scenario = scenario;
            FlowControlMode = flowControlMode;
            Padding = 0;
        }
    }

    public class TestParamUtil
    {
        public static bool CheckValues(TestParam testParam)
        {
            if (!Enum.IsDefined(typeof(TestScenario), testParam.Scenario))
            {
                Console.WriteLine("testParam.Scenario={0} is invalid", testParam.Scenario);
                return false;
            }
            if (!Enum.IsDefined(typeof(TestBaudRateType), testParam.BaudRate))
            {
                Console.WriteLine("testParam.BaudRate={0} is invalid", testParam.BaudRate);
                return false;
            }
            if (!Enum.IsDefined(typeof(TestFlowControlMode), testParam.FlowControlMode))
            {
                Console.WriteLine("testParam.FlowControlMode={0} is invalid", testParam.FlowControlMode);
                return false;
            }
            return true;
        }

        public static bool ToTestParam(out TestParam testParam, byte[] data, int dataCount)
        {
            testParam.Scenario = (TestScenario)data[0];
            testParam.BaudRate = (TestBaudRateType)data[1];
            testParam.FlowControlMode = (TestFlowControlMode)data[2];
            testParam.Padding = 0;
            return CheckValues(testParam);
        }
    }
}
