﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunnerTest.TestNodeInfoTest
{
    using System.Collections.Generic;
    using System.Linq;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using TestRunner;
    using TestRunner.Executer;

    /// <summary>
    /// [TestRunner.TestNodeInfo]::GetTestContexts用のテスト関数を定義します。
    /// </summary>
    [TestClass]
    public class GetTestContextsTest
    {
        /// <summary>
        /// 不変条件: テストコンテキストの情報は生成元のノードの情報に基づく
        /// </summary>
        [TestMethod]
        public void GetTestContextsInvariantTest001()
        {
            var testContexts = new TestNodeInfo(new Dictionary<string, object>()
            {
                { "Path", "Foo" }
            }).GetTestContexts();

            Assert.AreEqual(1, testContexts.Count());

            Assert.AreEqual(1u, testContexts[0].UnitCount);
            Assert.AreEqual(1u, testContexts[0].UnitId);
            Assert.AreEqual(string.Empty, testContexts[0].TestName);
            Assert.AreEqual(string.Empty, testContexts[0].Option);
            Assert.AreEqual(string.Empty, testContexts[0].Parameter);
            Assert.AreEqual(ResultCode.PASS, testContexts[0].ResultCode);
            Assert.AreEqual(ProcessType.Standard, testContexts[0].ProcessType);
            Assert.AreEqual(0, testContexts[0].ExitCode);
            Assert.AreEqual("Foo", testContexts[0].TargetPath);

            testContexts = new TestNodeInfo(new Dictionary<string, object>()
            {
                { "Timeout", "45" },
                { "Platform", "Win32" },
                { "BuildType", "Debug" },
                {
                    "Units",
                    new List<object>()
                    {
                        new Dictionary<string, object>()
                        {
                            { "Path", "Foo" },
                            { "TestName", "Hoge" },
                            { "Option", "Bar" },
                            { "ProcessType", "Background" },
                            { "TargetName", "MY-TARGET-NAME-1" },
                            { "TargetInterface", "MY-TARGET-INTERFACE-1" },
                        },
                        new Dictionary<string, object>()
                        {
                            { "ProgramName", "Baz" },
                            { "Parameter", "Qux" },
                            { "ProcessType", "Standard" },
                            { "TargetName", "MY-TARGET-NAME-2" },
                            { "TargetInterface", "MY-TARGET-INTERFACE-2" },
                        }
                    }
                }
            }).GetTestContexts();

            Assert.AreEqual(2, testContexts.Count());

            Assert.AreEqual("Hoge", testContexts[0].TestName);
            Assert.AreEqual(2u, testContexts[0].UnitCount);
            Assert.AreEqual(1u, testContexts[0].UnitId);
            Assert.AreEqual("MY-TARGET-NAME-1", testContexts[0].TargetNamePattern);
            Assert.AreEqual("MY-TARGET-INTERFACE-1", testContexts[0].TargetInterfacePattern);
            Assert.AreEqual(ResultCode.PASS, testContexts[0].ResultCode);
            Assert.AreEqual("Bar", testContexts[0].Option);
            Assert.AreEqual(string.Empty, testContexts[0].Parameter);
            Assert.AreEqual(ProcessType.Background, testContexts[0].ProcessType);
            Assert.AreEqual(45, testContexts[0].Timeout);
            Assert.AreEqual("Win32", testContexts[0].Platform);
            Assert.AreEqual("Debug", testContexts[0].BuildType);
            Assert.AreEqual(0, testContexts[0].ExitCode);
            Assert.AreEqual("Foo", testContexts[0].TargetPath);
            Assert.AreEqual(string.Empty, testContexts[0].TargetProgramName);

            Assert.AreEqual(string.Empty, testContexts[1].TestName);
            Assert.AreEqual(2u, testContexts[1].UnitCount);
            Assert.AreEqual(2u, testContexts[1].UnitId);
            Assert.AreEqual("MY-TARGET-NAME-2", testContexts[1].TargetNamePattern);
            Assert.AreEqual("MY-TARGET-INTERFACE-2", testContexts[1].TargetInterfacePattern);
            Assert.AreEqual(ResultCode.PASS, testContexts[1].ResultCode);
            Assert.AreEqual(string.Empty, testContexts[1].Option);
            Assert.AreEqual("Qux", testContexts[1].Parameter);
            Assert.AreEqual(ProcessType.Standard, testContexts[1].ProcessType);
            Assert.AreEqual(45, testContexts[1].Timeout);
            Assert.AreEqual("Win32", testContexts[1].Platform);
            Assert.AreEqual("Debug", testContexts[1].BuildType);
            Assert.AreEqual(0, testContexts[1].ExitCode);
            Assert.AreEqual(string.Empty, testContexts[1].TargetPath);
            Assert.AreEqual("Baz", testContexts[1].TargetProgramName);
        }
    }
}
