﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    [TestClass]
    public class NnBufferCppCodeEmitterTest
    {
        [CppFullName(@"nnt::Struct")]
        public struct Struct
        {
            public int A;
        }

        [TestMethod]
        public void TestGetCppTypeString()
        {
            Assert.AreEqual(@"::nn::sf::InBuffer", typeof(nn.sf.InBuffer).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"nn::sf::OutBuffer", typeof(nn.sf.OutBuffer).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"::nn::sf::InArray<::nnt::Struct>", typeof(nn.sf.InArray<Struct>).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"nn::sf::InArray<nnt::Struct>", typeof(nn.sf.InArray<Struct>).GetSfEntity().GetCppTypeString(true));
            Assert.AreEqual(@"::nn::sf::OutArray<::nnt::Struct>", typeof(nn.sf.OutArray<Struct>).GetSfEntity().GetCppTypeString(false));
            Assert.AreEqual(@"nn::sf::OutArray<nnt::Struct>", typeof(nn.sf.OutArray<Struct>).GetSfEntity().GetCppTypeString(true));
        }

        [TestMethod]
        public void TestGetParameterString()
        {
            Assert.AreEqual(@"const ::nn::sf::InBuffer& foo", typeof(nn.sf.InBuffer).GetSfEntity().GetParameterString(@"foo", InOutType.In, false));
            Assert.AreEqual(@"const nn::sf::OutBuffer& foo", typeof(nn.sf.OutBuffer).GetSfEntity().GetParameterString(@"foo", InOutType.In, true));
            Assert.AreEqual(@"const ::nn::sf::InArray<::nnt::Struct>& foo", typeof(nn.sf.InArray<Struct>).GetSfEntity().GetParameterString(@"foo", InOutType.In, false));
            Assert.AreEqual(@"const nn::sf::InArray<nnt::Struct>& foo", typeof(nn.sf.InArray<Struct>).GetSfEntity().GetParameterString(@"foo", InOutType.In, true));
            Assert.AreEqual(@"const ::nn::sf::OutArray<::nnt::Struct>& foo", typeof(nn.sf.OutArray<Struct>).GetSfEntity().GetParameterString(@"foo", InOutType.In, false));
            Assert.AreEqual(@"const nn::sf::OutArray<nnt::Struct>& foo", typeof(nn.sf.OutArray<Struct>).GetSfEntity().GetParameterString(@"foo", InOutType.In, true));
            // outParameter は NnBuffer に未定義
        }

        [TestMethod]
        public void TestGetStructPlacedString()
        {
            AssertionUtility.AssertException<WrongImplementationException>(
                () => typeof(nn.sf.InBuffer).GetSfEntity().GetStructPlacedString(@"foo", false),
                _ => { });
            AssertionUtility.AssertException<WrongImplementationException>(
                () => typeof(nn.sf.InBuffer).GetSfEntity().GetStructPlacedString(@"foo", true),
                _ => { });
        }

        [TestMethod]
        public void TestGetExternalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(new[] { @"<nn/sf/sf_Types.h>" }, typeof(nn.sf.InBuffer).GetSfEntity().GetExternalIncludes());
        }

        [TestMethod]
        public void TestGetAdditionalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(Enumerable.Empty<string>(), typeof(nn.sf.InBuffer).GetSfEntity().GetAdditionalIncludes());
        }

        [TestMethod]
        public void TestEmitForwardDeclarationCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(nn.sf.InBuffer).GetSfEntity().EmitForwardDeclarationCode);
        }

        [TestMethod]
        public void TestEmitDefinitionCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(nn.sf.InBuffer).GetSfEntity().EmitDefinitionCode);
        }

        [TestMethod]
        public void TestEmitReferenceCheckCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(nn.sf.InBuffer).GetSfEntity().EmitReferenceCheckCode);
        }
    }
}
