﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    [TestClass]
    public class InheritanceCppCodeEmitterTest
    {
        [CppRefPath(@"<nnt/foo/IBase0.h>")]
        [CppFullName(@"nnt::foo::IBase0")]
        private interface IBase0 : nn.sf.IServiceObject
        {
            [MethodId(0)]
            void A();
        }
        [CppRefPath(@"<nnt/foo/IBase1.h>")]
        [CppFullName(@"nnt::foo::IBase1")]
        private interface IBase1 : IBase0
        {
            [MethodId(1)]
            void B();
        }
        [CppRefPath(@"<nnt/bar/IDerived.h>")]
        [CppFullName(@"nnt::bar::IDerived")]
        private interface IDerived : IBase1
        {
            [MethodId(2)]
            void C();
        }

        [TestMethod]
        public void TestInheritance()
        {
            // CmifCppCodeEmission
            GenerateTestUtility.AssertGeneratedString(g =>
            {
                new CppCodeGenerator().Generate(g, typeof(IDerived));
            }, @"#include <nnt/foo/IBase1.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nnt { namespace bar {

class IDerived;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDerived, (::nnt::foo::IBase1))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDerived)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(C)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDerived)

        void C() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(C);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDerived : public ::nnt::foo::IBase1
    {
    public:
        void C() NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    void A() NN_NOEXCEPT;
    void B() NN_NOEXCEPT;
    void C() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nnt::bar::IDerived), (::nnt::foo::IBase1))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(C)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(C);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nnt::bar::IDerived>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nnt::bar::IDerived), (::nnt::foo::IBase1))

    // void C() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(C)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(C)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nnt::bar::IDerived, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nnt::bar::IDerived), (::nnt::foo::IBase1))

    // void C() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(C)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(C)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(C)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nnt::bar::IDerived>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nnt::bar::IDerived), (::nnt::foo::IBase1))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(C)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(C)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(C)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nnt::bar::IDerived))
");
        }
    }
}
