﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    [TestClass]
    public class ImplCppCodeEmitterTest
    {
        [CppFullName(@"nnt::ISimple")]
        [CppRefPath(@"<nnt/ISimple.h>")]
        [UseCmif(false)]
        private interface ISimple : nn.sf.IServiceObject
        {
        }

        [TestMethod]
        public void TestGetExternalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(new[] { @"<nnt/ISimple.h>" }, typeof(ISimple).GetSfEntity().GetExternalIncludes());
        }

        [TestMethod]
        public void TestGetAdditionalIncludes()
        {
            AssertionUtility.AssertAreSetEqual(new[] { @"<nn/sf/detail/sf_AutogenInterfaceIncludes.h>", @"<nn/sf/impl/detail/sf_AutogenImplIncludes.h>" }, typeof(ISimple).GetSfEntity().GetAdditionalIncludes());
        }

        [TestMethod]
        public void TestEmitForwardDeclarationCode()
        {
            GenerateTestUtility.AssertGeneratedString(g =>
            {
                g.Newline();
                typeof(ISimple).GetSfEntity().EmitForwardDeclarationCode(g);
                g.AutoNewLine();
                g.CloseCurrentNamespace();
            }, @"
namespace nnt {

class ISimple;

}
");
        }

        [CppFullName(@"nnt::IChild")]
        private interface IChild : nn.sf.IServiceObject
        {
        }

        [CppRefPath(@"<nnt/IComplex.h>")]
        [CppFullName(@"nnt::IComplex")]
        [UseCmif(false)]
        private interface IComplex : nn.sf.IServiceObject
        {
            [MethodId(0)]
            [UseCmif(false)]
            void A();
            [MethodId(1)]
            [UseCmif(false)]
            void B(short s16);
            [MethodId(2)]
            [UseCmif(false)]
            void C(int s32, long s64);
            [MethodId(3)]
            [UseCmif(false)]
            nn.Result D();
            [MethodId(4)]
            [UseCmif(false)]
            nn.Result E(ushort u16);
            [MethodId(5)]
            [UseCmif(false)]
            nn.Result F(uint u32, ulong u64);
            [MethodId(6)]
            [UseCmif(false)]
            ushort G();
            [MethodId(7)]
            [UseCmif(false)]
            uint H(nn.sf.InBuffer inBuffer, nn.sf.OutBuffer outBuffer);
            [MethodId(8)]
            [UseCmif(false)]
            uint L(nn.sf.InArray<int> inArray, nn.sf.OutArray<int> outArray);
            [MethodId(9)]
            [UseCmif(false)]
            void O(nn.sf.Out<int> pOut);
            [MethodId(10)]
            [UseCmif(false)]
            IChild ReturnChild();
            [MethodId(11)]
            [UseCmif(false)]
            void InChild(IChild p);
            [MethodId(12)]
            [UseCmif(false)]
            void OutChild(nn.sf.Out<IChild> pOut);
            [MethodId(13)]
            [UseCmif(false)]
            void InNativeHandle([MoveHandle] nn.sf.NativeHandle x);
            [MethodId(14)]
            [UseCmif(false)]
            void OutNativeHandle(nn.sf.Out<nn.sf.NativeHandle> pOut);
            [MethodId(15)]
            [UseCmif(false)]
            void MoveOutNativeHandle([MoveHandleAttribute] nn.sf.Out<nn.sf.NativeHandle> pOut);
            [MethodId(16)]
            [UseCmif(false)]
            void InProcessId([ProcessId] nn.Bit64 pid);
        }

        [TestMethod]
        public void TestEmitDefinitionCode()
        {
            GenerateTestUtility.AssertGeneratedString(g =>
            {
                g.Newline();
                typeof(IComplex).GetSfEntity().EmitDefinitionCode(g);
                g.AutoNewLine();
                g.CloseCurrentNamespace();
            }, @"
namespace nnt {

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IComplex, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IComplex)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(A)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(B, (::std::int16_t s16))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(C, (::std::int32_t s32, ::std::int64_t s64))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(D)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(E, (::std::uint16_t u16))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(F, (::std::uint32_t u32, ::std::uint64_t u64))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(G, (::std::uint16_t))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(H, (::std::uint32_t), (const ::nn::sf::InBuffer& inBuffer, const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_N(L, (::std::uint32_t), (const ::nn::sf::InArray<::std::int32_t>& inArray, const ::nn::sf::OutArray<::std::int32_t>& outArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(O, (::nn::sf::Out<::std::int32_t> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(ReturnChild, (::nn::sf::SharedPointer<::nnt::IChild>))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(InChild, (::nn::sf::SharedPointer<::nnt::IChild> p))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(OutChild, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::IChild>> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(InNativeHandle, (::nn::sf::NativeHandle&& x))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(OutNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(MoveOutNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(InProcessId, (::nn::Bit64 pid))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IComplex)

        void A() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(A);
        }

        void B(::std::int16_t s16) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(B, (s16));
        }

        void C(::std::int32_t s32, ::std::int64_t s64) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(C, (s32, s64));
        }

        ::nn::Result D() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(D);
        }

        ::nn::Result E(::std::uint16_t u16) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(E, (u16));
        }

        ::nn::Result F(::std::uint32_t u32, ::std::uint64_t u64) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(F, (u32, u64));
        }

        ::std::uint16_t G() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(G, (::std::uint16_t));
        }

        ::std::uint32_t H(const ::nn::sf::InBuffer& inBuffer, const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(H, (::std::uint32_t), (inBuffer, outBuffer));
        }

        ::std::uint32_t L(const ::nn::sf::InArray<::std::int32_t>& inArray, const ::nn::sf::OutArray<::std::int32_t>& outArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_N(L, (::std::uint32_t), (inArray, outArray));
        }

        void O(::nn::sf::Out<::std::int32_t> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(O, (pOut));
        }

        ::nn::sf::SharedPointer<::nnt::IChild> ReturnChild() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(ReturnChild, (::nn::sf::SharedPointer<::nnt::IChild>));
        }

        void InChild(::nn::sf::SharedPointer<::nnt::IChild> p) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(InChild, (p));
        }

        void OutChild(::nn::sf::Out<::nn::sf::SharedPointer<::nnt::IChild>> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(OutChild, (pOut));
        }

        void InNativeHandle(::nn::sf::NativeHandle&& x) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(InNativeHandle, (::std::move(x)));
        }

        void OutNativeHandle(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(OutNativeHandle, (pOut));
        }

        void MoveOutNativeHandle(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(MoveOutNativeHandle, (pOut));
        }

        void InProcessId(::nn::Bit64 pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(InProcessId, (pid));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IComplex
    {
    public:
        void A() NN_NOEXCEPT;
        void B(std::int16_t s16) NN_NOEXCEPT;
        void C(std::int32_t s32, std::int64_t s64) NN_NOEXCEPT;
        nn::Result D() NN_NOEXCEPT;
        nn::Result E(std::uint16_t u16) NN_NOEXCEPT;
        nn::Result F(std::uint32_t u32, std::uint64_t u64) NN_NOEXCEPT;
        std::uint16_t G() NN_NOEXCEPT;
        std::uint32_t H(const nn::sf::InBuffer& inBuffer, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        std::uint32_t L(const nn::sf::InArray<std::int32_t>& inArray, const nn::sf::OutArray<std::int32_t>& outArray) NN_NOEXCEPT;
        void O(nn::sf::Out<std::int32_t> pOut) NN_NOEXCEPT;
        nn::sf::SharedPointer<nnt::IChild> ReturnChild() NN_NOEXCEPT;
        void InChild(nn::sf::SharedPointer<nnt::IChild> p) NN_NOEXCEPT;
        void OutChild(nn::sf::Out<nn::sf::SharedPointer<nnt::IChild>> pOut) NN_NOEXCEPT;
        void InNativeHandle(nn::sf::NativeHandle&& x) NN_NOEXCEPT;
        void OutNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
        void MoveOutNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
        void InProcessId(nn::Bit64 pid) NN_NOEXCEPT;
    };
#endif

}

#if 0

// Template for implementation users
class Impl
{
public:
    void A() NN_NOEXCEPT;
    void B(std::int16_t s16) NN_NOEXCEPT;
    void C(std::int32_t s32, std::int64_t s64) NN_NOEXCEPT;
    nn::Result D() NN_NOEXCEPT;
    nn::Result E(std::uint16_t u16) NN_NOEXCEPT;
    nn::Result F(std::uint32_t u32, std::uint64_t u64) NN_NOEXCEPT;
    std::uint16_t G() NN_NOEXCEPT;
    std::uint32_t H(const nn::sf::InBuffer& inBuffer, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    std::uint32_t L(const nn::sf::InArray<std::int32_t>& inArray, const nn::sf::OutArray<std::int32_t>& outArray) NN_NOEXCEPT;
    void O(nn::sf::Out<std::int32_t> pOut) NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::IChild> ReturnChild() NN_NOEXCEPT;
    void InChild(nn::sf::SharedPointer<nnt::IChild> p) NN_NOEXCEPT;
    void OutChild(nn::sf::Out<nn::sf::SharedPointer<nnt::IChild>> pOut) NN_NOEXCEPT;
    void InNativeHandle(nn::sf::NativeHandle&& x) NN_NOEXCEPT;
    void OutNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void MoveOutNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void InProcessId(nn::Bit64 pid) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nnt::IComplex))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(A)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(A);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(B, (::std::int16_t s16))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(B, (s16));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(C, (::std::int32_t s32, ::std::int64_t s64))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(C, (s32, s64));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(D)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(D);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(E, (::std::uint16_t u16))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(E, (u16));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(F, (::std::uint32_t u32, ::std::uint64_t u64))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(F, (u32, u64));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(G, (::std::uint16_t))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(G, (::std::uint16_t));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(H, (::std::uint32_t), (const ::nn::sf::InBuffer& inBuffer, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(H, (::std::uint32_t), (inBuffer, outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_N(L, (::std::uint32_t), (const ::nn::sf::InArray<::std::int32_t>& inArray, const ::nn::sf::OutArray<::std::int32_t>& outArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_N(L, (::std::uint32_t), (inArray, outArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(O, (::nn::sf::Out<::std::int32_t> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(O, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(ReturnChild, (::nn::sf::SharedPointer<::nnt::IChild>))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(ReturnChild, (::nn::sf::SharedPointer<::nnt::IChild>));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InChild, (::nn::sf::SharedPointer<::nnt::IChild> p))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(InChild, (p));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(OutChild, (::nn::sf::Out<::nn::sf::SharedPointer<::nnt::IChild>> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(OutChild, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InNativeHandle, (::nn::sf::NativeHandle&& x))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(InNativeHandle, (::std::move(x)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(OutNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(OutNativeHandle, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(MoveOutNativeHandle, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(MoveOutNativeHandle, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(InProcessId, (::nn::Bit64 pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(InProcessId, (pid));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END
");
        }

        [TestMethod]
        public void TestEmitReferenceCheckCode()
        {
            GenerateTestUtility.AssertGenerateEmpty(typeof(IComplex).GetSfEntity().EmitReferenceCheckCode);
        }
    }
}
