﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using static Nintendo.DebugBoardPlugin.Ft260Library;
namespace Nintendo.DebugBoardPlugin
{
    [TestClass]
    public class FT260LibraryTest
    {
        [TestMethod]
        public void GpioTest()
        {
            Ft260Library.EnableInterruptAndWakeUp(false);
            Ft260Library.EnableUartDcdRi(false);
            Gpio[] gpios = { Gpio.GPIO0, Gpio.GPIO1, Gpio.GPIO2, Gpio.GPIO3, Gpio.GPIO4, Gpio.GPIO5 };
            foreach (var gpio in gpios)
            {
                Ft260Library.SetGpioDirection(gpio, GpioDirection.Output);
            }
            GpioExt[] gpioExts = { GpioExt.GPIOA, GpioExt.GPIOB, GpioExt.GPIOC, GpioExt.GPIOD, GpioExt.GPIOE, GpioExt.GPIOF, GpioExt.GPIOG, GpioExt.GPIOH };
            foreach (var gpioExt in gpioExts)
            {
                Ft260Library.SetGpioDirection(gpioExt, GpioDirection.Output);
            }
        }
    }
}
