﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace PackageCreatorTest
{
    [TestClass]
    public class PackageTypeTest
    {
        [TestMethod]
        public void PublicTest()
        {
            var baseType = PackageCreator.PackageType.Type.Public;

            Assert.IsTrue((baseType | PackageCreator.PackageType.Type.Public) == baseType);
            Assert.IsFalse((baseType | PackageCreator.PackageType.Type.Private) == baseType);
            Assert.IsFalse((baseType | PackageCreator.PackageType.Type.Confidential) == baseType);
        }

        [TestMethod]
        public void PrivateTest()
        {
            var baseType = PackageCreator.PackageType.Type.Private;

            Assert.IsTrue((baseType | PackageCreator.PackageType.Type.Public) == baseType);
            Assert.IsTrue((baseType | PackageCreator.PackageType.Type.Private) == baseType);
            Assert.IsFalse((baseType | PackageCreator.PackageType.Type.Confidential) == baseType);

        }

        [TestMethod]
        public void ConfidentialTest()
        {
            var baseType = PackageCreator.PackageType.Type.Confidential;

            Assert.IsTrue((baseType | PackageCreator.PackageType.Type.Public) == baseType);
            Assert.IsTrue((baseType | PackageCreator.PackageType.Type.Private) == baseType);
            Assert.IsTrue((baseType | PackageCreator.PackageType.Type.Confidential) == baseType);
        }
    }
}
