﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.MakeVisualStudioProject.Generator;

namespace Nintendo.MakeVisualStudioProjectTest.Generator
{
    [TestClass]
    public class ProjectFiltersGeneratorTest
    {
        [TestMethod]
        public void TestConvertToShortPath()
        {
            var datas = new Tuple<IEnumerable<string>, IEnumerable<string>>[]
            {
                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] { @"..\a\b.txt" },
                    new[] { @"a\b.txt" }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] { @"..\a\b\c\test.txt" },
                    new[] { @"a%255cb%255cc\test.txt" }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] {
                        @"..\..\a\b\test.txt",
                        @"..\..\c\bar.txt"
                    },
                    new[] {
                        @"a%255cb\test.txt",
                        @"c\bar.txt"
                    }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] {
                        @"..\..\a\b\test.txt",
                        @"..\..\a\bar.txt"
                    },
                    new[] {
                        @"a\b\test.txt",
                        @"a\bar.txt"
                    }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] {
                        @"..\..\a\b\c\d\test.txt",
                        @"..\..\a\b\e\test.txt"
                    },
                    new[] {
                        @"a%255cb\c%255cd\test.txt",
                        @"a%255cb\e\test.txt"
                    }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] {
                        @"..\..\a\b\c\d\e\f\test.txt",
                        @"..\..\a\b\c\d\g\test.txt",
                        @"..\..\a\b\e\test.txt"
                    },
                    new[] {
                        @"a%255cb\c%255cd\e%255cf\test.txt",
                        @"a%255cb\c%255cd\g\test.txt",
                        @"a%255cb\e\test.txt"
                    }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] {
                        @"a\b\c\test.txt",
                        @"a\b\c\d\e\test.txt",
                        @"f\g\test.txt",
                        @"test.txt",
                    },
                    new[] {
                        @"a%255cb%255cc\test.txt",
                        @"a%255cb%255cc\d%255ce\test.txt",
                        @"f%255cg\test.txt",
                        @"test.txt",
                    }
                    ),

                new Tuple<IEnumerable<string>, IEnumerable<string>>(
                    new[] { @"..\.config" },
                    new[] { @".config" }
                    ),
            };

            foreach (var data in datas.Select((value, index) => new { value, index }))
            {
                var result = ProjectFiltersGenerator.ConvertToShortPath(data.value.Item1);

                Assert.IsTrue(result.SequenceEqual(data.value.Item2), $"Failed at pattern '{data.index}'\n" +
                    "expected = {0}, actual = {1}",
                    Utility.ToArrayString(data.value.Item2),
                    Utility.ToArrayString(result));
            }
        }
    }
}
