﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.MakeVisualStudioProject.Converter;

namespace Nintendo.MakeVisualStudioProjectTest.Converter
{
    [TestClass]
    public class OptionStringTokenizerTest
    {
        [TestMethod]
        public void TestTokenizer()
        {
            var testInstances = new Tuple<string, IEnumerable<string>>[]
            {
                new Tuple<string, IEnumerable<string>>("a b c", new[] { "a", "b", "c" }),
                new Tuple<string, IEnumerable<string>>("a   b", new[] { "a", "b" }),

                new Tuple<string, IEnumerable<string>>(" longstring=/-* ", new[] { "longstring=/-*" }),
                new Tuple<string, IEnumerable<string>>(" ", new string[0]),

                new Tuple<string, IEnumerable<string>>("-a Arguments",                  new[] { "-a", "Arguments" }),
                new Tuple<string, IEnumerable<string>>("-b \"Arguments with Space\"",   new[] { "-b", "Arguments with Space" }),
                new Tuple<string, IEnumerable<string>>("-c \"Arguments with 'Quote'\"", new[] { "-c", "Arguments with 'Quote'" }),
                new Tuple<string, IEnumerable<string>>("-d\"One Token\"",               new[] { "-dOne Token" }),

                new Tuple<string, IEnumerable<string>>("--arg0 --arg1\"arg 1\" --arg2 \"arg -- 2\" ", new[] { "--arg0", "--arg1arg 1", "--arg2", "arg -- 2" }),
            };

            foreach (var testInstance in testInstances)
            {
                var input = testInstance.Item1;
                var expected = testInstance.Item2;
                var actual = OptionStringTokenizer.Tokenize(input);

                Assert.IsTrue(
                    actual.SequenceEqual(expected),
                    "expected = {0}, actual = {1}",
                    Utility.ToArrayString(expected),
                    Utility.ToArrayString(actual));
            }
        }
    }
}
