﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeNrrTest
{
    public class TestBase
    {
        public const string TestNroFile1 = "TestNro1.nro";
        public const string TestNroFile2 = "TestNro2.nro";

        public TestContext TestContext { get; set; }
        public string GetTestNroFilePath(string fileName)
        {
            TestUtility.TestPath testPath = new TestUtility.TestPath(this.TestContext);
            return testPath.GetSigloRoot() + "\\Externals\\TestBinaries\\Tools\\MakeNrrTest\\" + fileName;
        }


        public string ExecuteProgram(string[] inputFiles, FileManager outputFile, string additionalParam = "", bool testMode = false)
        {
            if (!testMode)
            {
                System.Diagnostics.Process process = new System.Diagnostics.Process();
                TestUtility.TestPath testPath = new TestUtility.TestPath(this.TestContext);

                string inputLine = "";
                foreach (var f in inputFiles)
                {
                    inputLine += string.Format("{0} ", f);
                }

                process.StartInfo.FileName = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\MakeNrr\\MakeNrr.exe";
                process.StartInfo.Arguments = string.Format("{0} -o {1} {2}", additionalParam, outputFile.FilePath, inputLine);
                process.StartInfo.CreateNoWindow = true;
                process.StartInfo.UseShellExecute = false;
                process.StartInfo.RedirectStandardError = true;
                process.Start();

                string errorMsg = process.StandardError.ReadToEnd();
                process.WaitForExit();

                return errorMsg;
            }
            else
            {
                List<string> argList = new List<string>();
                if (additionalParam != null && additionalParam.Length > 0)
                {
                    argList.Add(additionalParam);
                }
                argList.Add("-o");
                argList.Add(outputFile.FilePath);
                argList.AddRange(inputFiles);

                using (MemoryStream ms = new MemoryStream())
                {
                    StreamWriter sw = new StreamWriter(ms);
                    Console.SetError(sw);
                    MakeNrr.Program.Main(argList.ToArray());
                    if (ms.Length > 0)
                    {
                        return System.Text.Encoding.UTF8.GetString(ms.ToArray());
                    }
                    else
                    {
                        return "";
                    }
                }
            }
        }

        public FileManager SuccessExecute(string[] inputFiles, string additionalParam = "", bool testMode = false)
        {
            FileManager outputNrr = new FileManager();
            string err = ExecuteProgram(inputFiles, outputNrr, additionalParam, testMode);
            Assert.IsTrue(err.Length == 0, err);
            Assert.IsTrue(System.IO.File.Exists(outputNrr.FilePath));
            return outputNrr;
        }

        public void FailExecute(string[] inputFiles, string errMsg, string additionalParam = "", bool testMode = false)
        {
            FileManager tmpFile = new FileManager();
            string err = ExecuteProgram(inputFiles, tmpFile, additionalParam, testMode);
            Assert.IsTrue(err.Length > 0);
            if (errMsg != null)
            {
                Assert.IsTrue(err.IndexOf(errMsg) >= 0);
            }
            Assert.IsFalse(System.IO.File.Exists(tmpFile.FilePath));
        }
    }
}

