﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeNroTest
{
    public static class NroBinaryFormat
    {
        public const int RocrtOffsetOffset         = 0x4;
        public const int HeaderOffset              = 0x10;
    }

    public static class NroHeaderFormat
    {
        public const uint Signature                = 0x304F524E;
        public const int SignatureOffset           = 0x0;
        public const int VersionOffset             = 0x4;
        public const int SizeOffset                = 0x8;
        public const int MiscFlagOffset            = 0xc;
        public const int TextAddressOffset         = 0x10;
        public const int TextSizeOffset            = 0x14;
        public const int RoDataAddressOffset       = 0x18;
        public const int RoDataSizeOffset          = 0x1c;
        public const int DataAddressOffset         = 0x20;
        public const int DataSizeOffset            = 0x24;
        public const int BssSizeOffset             = 0x28;
        public const int Reserve0x2C               = 0x2c;
        public const int ModuleIdOffset            = 0x30;
        public const int Reserve0x60               = 0x50;
    }

    public static class RocrtModuleHeaderFormat
    {
        public const uint Signature                = 0x30444F4D;
        public const int SignatureOffset           = 0x0;
        public const int DynamicOffsetOffset       = 0x4;
        public const int BssStartOffsetOffset      = 0x8;
        public const int BssEndOffsetOffset        = 0xc;
        public const int ExceptionInfoStartOffset  = 0x10;
        public const int ExceptionInfoEndOffset    = 0x14;
        public const int ModuleOffsetOffset        = 0x18;
    }
}
