﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Collections.Generic;
using System.IO;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeDescTest
{
    public class TestDataForSrv
    {
        public static XmlElement MakeSrvEntry(string name, string isServer)
        {
            XmlElement entry = new XmlElement("Entry");

            if (name != null)
            {
                XmlElement nameEntry = new XmlElement("Name");
                nameEntry.InnerText = name;
                entry.AddChild(nameEntry);
            }

            if (isServer != null)
            {
                XmlElement isServerEntry = new XmlElement("IsServer");
                isServerEntry.InnerText = isServer;
                entry.AddChild(isServerEntry);
            }

            return entry;
        }
    }
}
