﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/crypto/crypto_RsaPssSha256Verifier.h>
#include <nnt/gtest/gtest.h>

extern char NpdmSample_begin[];
extern char NpdmSample_end[];

const int SignatureSize = 0x100;
char g_Modulus[] = { 0xAE,0x1B,0x10,0x6C,0x77,0x9D,0x41,0x65,0x83,0xB1,0x46,0x73,0x18,0xBC,0x33,0xA1,0x7E,0x85,0xCD,0x64,0x57,0xC9,0x82,0xC0,0xFB,0x21,0xC0,0x45,0xEC,0x8D,0x57,0x60,0xF6,0xAD,0x65,0x76,0x0A,0x25,0xA9,0x4D,0x71,0x95,0xF7,0xC3,0x35,0x51,0x2E,0xA6,0xCA,0xBF,0x62,0xD5,0x50,0xFF,0xF0,0x9E,0x16,0x25,0x8C,0x22,0x27,0x25,0xA6,0x80,0xA8,0x6A,0x7F,0x1A,0xBD,0xCE,0xB6,0xED,0x95,0xF1,0x73,0x45,0x03,0xD1,0x78,0x4B,0xDB,0x03,0x05,0x52,0x02,0x6E,0xA7,0xF7,0x2D,0x3D,0x65,0x1D,0xDB,0x61,0x60,0x54,0xC3,0x1D,0xA2,0x3A,0x49,0x22,0x80,0x55,0xA3,0x46,0x69,0x7F,0x29,0xC8,0xA6,0x2D,0x43,0x7B,0x20,0xCD,0xCA,0x9E,0x60,0x29,0x96,0xAD,0xC5,0xF0,0x71,0xFB,0x0E,0x5A,0x44,0xC7,0xED,0x99,0x26,0xCD,0x1F,0xCC,0xF1,0xC3,0x6E,0x09,0x64,0x09,0xCA,0x60,0x5B,0x7F,0x3A,0x1D,0xA8,0x9C,0x56,0x38,0x63,0x42,0x21,0xBF,0xB0,0xA6,0x26,0x87,0x51,0xCF,0x77,0xC1,0x61,0xDC,0x62,0x07,0x2A,0x23,0x66,0xF7,0xED,0xFB,0x48,0x81,0xF8,0x05,0xAB,0xA0,0x02,0x69,0x51,0x78,0xDF,0xBC,0x60,0x81,0xC7,0x6C,0x34,0xA4,0x38,0xA9,0x26,0x9D,0xD0,0xB8,0xE4,0x95,0xC8,0x7B,0xAE,0x83,0x26,0xC8,0x75,0x38,0x67,0xDE,0x88,0x38,0x22,0xDE,0x9F,0x8C,0x54,0xDB,0x60,0xBA,0x65,0x17,0x19,0x1C,0x29,0xFD,0x6F,0xAC,0x4E,0xE8,0x97,0x5B,0xBC,0x92,0xA1,0x76,0x28,0x70,0x3E,0x2D,0x37,0xD6,0xD2,0x36,0x75,0xC8,0x68,0xF4,0x2A,0x87,0x2A,0x39,0x1C,0xCD,0xD9,0x77 };

char g_PublicExponent[] = { 0x01,0x00,0x01 };

TEST(MakeDesc, TestAcidSignature)
{
    const size_t AcidOffset = 0x80;
    const size_t SignatureAreaSizeOffset = 0x204;
    const size_t SignatureAreaOffset = 0x100;

    char* acid = &NpdmSample_begin[AcidOffset];
    uint32_t signatureAreaSize = *reinterpret_cast<uint32_t*>(&acid[SignatureAreaSizeOffset]);

    bool check = nn::crypto::VerifyRsa2048PssSha256(
            acid, SignatureSize,
            g_Modulus, sizeof(g_Modulus),
            g_PublicExponent, sizeof(g_PublicExponent),
            &acid[SignatureAreaOffset],signatureAreaSize
            );

    ASSERT_TRUE(check);
}
