﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.HtcTools;
using Nintendo.HtcTools.Htclow;
using Nintendo.HtcTools.HtcToolsTestCommonLibrary;

namespace Nintendo.HtcTools.Htclow
{
    internal class HtclowLibraryTestService : IDisposable
    {
        private NetworkEmulationStream m_Stream;

        public IDictionary<Channel, long> SequenceIds { get; private set; } = new Dictionary<Channel, long>();
        public HtclowClient HtclowClient { get; private set; }

        public HtclowLibraryTestService(bool removeOldData = false)
        {
            m_Stream = new NetworkEmulationStream(removeOldData);
            HtclowClient = new HtclowClient(m_Stream) { RetransmitEnable = false };
        }

        public Packet ReceivePacket()
        {
            var buffer = m_Stream.ReadFromTest(Packet.HeaderSize);
            var header = new Packet(buffer);

            var packet = new Packet(header, header.BodySize);

            // ボディ受信
            if (header.BodySize != 0)
            {
                var body = m_Stream.ReadFromTest(header.BodySize);
                packet.SetBody(body);
            }

            return packet;
        }

        public void SendPacket(Packet packet)
        {
            // シーケンス ID 付与
            if (packet.PacketType == PacketType.Data || packet.PacketType == PacketType.Fin || packet.PacketType == PacketType.Syn)
            {
                if (!SequenceIds.ContainsKey(packet.Channel))
                {
                    SequenceIds.Add(packet.Channel, 0);
                }

                packet.SequenceId = SequenceIds[packet.Channel];

                // シーケンス ID 更新
                SequenceIds[packet.Channel]++;
            }

            m_Stream.WriteFromTest(packet.GetBytes());
        }

        #region IDisposable Support
        private bool disposedValue = false; // 重複する呼び出しを検出するには

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    HtclowClient.Dispose();
                    m_Stream.Close();
                }

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(true);
        }
        #endregion
    }
}
