﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.HtcTools.HtcfsLibrary;

namespace Nintendo.HtcTools.HtcfsLibraryTest
{
    [TestClass]
    public sealed class HtcfsProtocolVersionTest : IDisposable
    {
        private readonly HtcfsLibraryTestService testService;

        public HtcfsProtocolVersionTest()
        {
            testService = new HtcfsLibraryTestService();
        }

        public void Dispose()
        {
            testService.Dispose();
        }

        [TestMethod]
        public void GetMaxProtocolVersion()
        {
            var result = testService.GetMaxProtocolVersion(out var version);

            Assert.IsTrue(version == Constants.MaxVersion);
            Assert.AreEqual(HtcfsResult.Success, result);
        }

        [TestMethod]
        public void SetProtocolVersion()
        {
            const int InvalidProtocolVersion = Constants.MaxVersion + 1;

            HtcfsResult result;

            result = testService.SetProtocolVersion(Constants.MaxVersion);
            Assert.AreEqual(HtcfsResult.Success, result);

            result = testService.SetProtocolVersion(InvalidProtocolVersion);
            Assert.AreEqual(HtcfsResult.UnsupportedVersion, result);
        }
    }
}
