﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.HtcTools.HtcfsLibrary;

namespace Nintendo.HtcTools.HtcfsLibraryTest
{
    /// <summary>
    /// testFs_OpenMode に相当するテストを HtcfsLibrary 単体で行う
    /// </summary>
    [TestClass]
    public sealed class HtcfsOpenModeTest : IDisposable
    {
        private readonly OpenMode[] OpenFileModes =
        {
            OpenMode.Read,
            OpenMode.Read | OpenMode.AllowAppend,
            OpenMode.Write,
            OpenMode.Write | OpenMode.AllowAppend,
        };

        private const long FileSize = 32;

        private readonly HtcfsLibraryTestService testService;
        private readonly string filePath;

        public HtcfsOpenModeTest()
        {
            testService = new HtcfsLibraryTestService();
            filePath = $"{testService.TestRootPath}/test.file";
            testService.CreateFile(filePath, FileSize);
        }

        public void Dispose()
        {
            testService.Dispose();
        }

        [TestMethod]
        public void FlushFile()
        {
            foreach (var mode in OpenFileModes)
            {
                CompoundResult result;

                result = testService.OpenFile(out var handle, filePath, mode);
                Assert.IsTrue(result.IsSuccess());

                result = testService.FlushFile(handle);
                Assert.IsTrue(result.IsSuccess());

                result = testService.CloseFile(handle);
                Assert.IsTrue(result.IsSuccess());
            }
        }

        [TestMethod]
        public void GetFileSize()
        {
            foreach (var mode in OpenFileModes)
            {
                CompoundResult result;

                result = testService.OpenFile(out var handle, filePath, mode);
                Assert.IsTrue(result.IsSuccess());

                result = testService.GetFileSize(out var fileSize, handle);
                Assert.IsTrue(result.IsSuccess());

                result = testService.CloseFile(handle);
                Assert.IsTrue(result.IsSuccess());
            }
        }
    }
}
