﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.Htcs;
using System.Threading;

namespace HtcDaemonTest
{
    [TestClass]
    public class HtcsTest
    {
        /// <summary>
        /// HtcsCommunicator.Start() を呼び出した後、
        /// HtcsCommunicator.Stop() を呼び出して、Start() が返ることを確かめます。
        ///
        /// SIGLO-11533 の再現するためのコードです。
        /// CI でテストすることは意図していません。
        /// </summary>
        [TestMethod]
        public void TestStartStop()
        {
            HtcsCommunicator communicator = new HtcsCommunicator();

            bool result = true;
            Thread startThread = new Thread((object data) =>
            {
                result = communicator.Start();
            });

            startThread.Start();

            // communicator.Start() が呼ばれるのを待つ
            Thread.Sleep(100);
            communicator.Stop();

            startThread.Join();

            Assert.IsFalse(result);
        }
    }
}
