﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.Hid
{
    using System;
    using System.IO;

    internal class NetworkBinaryWriter : IDisposable
    {
        private bool disposed = false;
        private BinaryWriter binaryWriter;

        internal NetworkBinaryWriter(Stream input)
        {
            this.binaryWriter = new BinaryWriter(input);
        }

        ~NetworkBinaryWriter()
        {
            this.Dispose(false);
        }

        public void Dispose()
        {
            this.Dispose(true);

            GC.SuppressFinalize(this);
        }

        internal void Write(byte value)
        {
            this.binaryWriter.Write(value);
        }

        internal void Write(byte[] buffer)
        {
            this.binaryWriter.Write(buffer);
        }

        internal void Write(ushort value)
        {
            this.binaryWriter.Write(Utility.ConvertToBigEndian(BitConverter.GetBytes(value)));
        }

        internal void Write(long value)
        {
            this.binaryWriter.Write(Utility.ConvertToBigEndian(BitConverter.GetBytes(value)));
        }

        protected void Dispose(bool disposing)
        {
            if (this.disposed)
            {
                return;
            }

            if (disposing)
            {
                this.binaryWriter.Dispose();
            }

            this.disposed = true;
        }
    }
}
