﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.Hid
{
    using System;

    public class DebugPadButtonsState
    {
        private readonly ushort state;

        internal DebugPadButtonsState(ushort state)
        {
            this.state = state;
        }

        public bool GetButton(DebugPadButton button)
        {
            return (this.state & (ushort)button) != 0;
        }

        public override int GetHashCode()
        {
            return this.state;
        }

        public override bool Equals(object obj)
        {
            var other = obj as DebugPadButtonsState;

            if (other == null)
            {
                return false;
            }
            else
            {
                return this.state == other.state;
            }
        }
    }
}
