﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using GitExternalStorage;
using GitExternalStorage.Commands;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace GitExternalStorageTest
{
    [TestClass]
    public class UnitTestCommand
    {
        public TestContext TestContext { get; set; }

        [TestMethod]
        public void TestFilterCleanCommand()
        {
            var inputFilePath = Path.Combine(Utils.GetTestProjectRoot(this.TestContext), @"TestData\TestData.txt");
            var outputFilePath = @"output.txt";
            var errorFilePath = @"error.txt";

            var console = new FileCommandConsole(inputFilePath, outputFilePath, errorFilePath);
            var command = new FilterCleanCommand(console);

            command.Run();

            var output = File.ReadAllText(outputFilePath);
            var expected = "GitExternalStorage:27816852d8edbe8a05741b27aaa7c2d413f9b9ef";

            Assert.AreEqual<string>(expected, output);

            File.Delete(outputFilePath);
            File.Delete(errorFilePath);
        }
    }
}
