﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Diagnostics;
using System.IO;

namespace ErrorMessageDatabaseConverterTest
{
    [TestClass]
    public class ExecutionTest
    {
        public TestContext TestContext { get; set; }

        public string TestDataDirectory
        {
            get
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                return testPath.GetSigloRoot() + "\\Tests\\Tools\\Sources\\Tests\\ErrorMessageDatabaseConverterTest\\TestData";
            }
        }

        public string ExePath
        {
            get
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                // とりあえず Release 以下のプログラムを使う。
                return Path.Combine(testPath.GetSigloRoot(), @"Programs\Eris\Outputs\AnyCPU\Tools\ErrorMessageDatabaseConverter\ErrorMessageDatabaseConverter\Release\ErrorMessageDatabaseConverter.exe");
            }
        }

        [TestMethod]
        public void TestExecution()
        {
            Process process = new Process();
            TestUtility.TestPath testPath = new TestUtility.TestPath(this.TestContext);

            process.StartInfo.FileName = ExePath;
            string outDir = Path.Combine(TestDataDirectory, "out");
            process.StartInfo.Arguments = "--error_list " + Path.Combine(TestDataDirectory, "TestErrorList.xml") + " --output " + outDir;
            process.StartInfo.CreateNoWindow = true;
            process.Start();

            process.WaitForExit();

            Assert.AreEqual(0, process.ExitCode);

            // TODO: 作成したデータの検証

            Directory.Delete(outDir, true);

        }
    }
}
