﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.UIControls.TestTypes;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Class containing unit tests about XamlControl.
    /// </summary>
    [TestClass]
    public class XamlControlUnitTests
    {
        /// <summary>
        /// Test to instance a TestXamlUserControl class and
        /// make sure it properly load all controls.
        /// </summary>
        [TestMethod]
        public void TestXamlUserControl01()
        {
            var form = new Form();
            form.Visible = true;

            var ctrl = new TestXamlControl();
            ctrl.Visible = true;

            form.Controls.Add(ctrl);

            if (ctrl.IsSuccessful == false)
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Tests the custom XamlObjectWriter.
        /// </summary>
        [TestMethod]
        public void TestXamlWriter01()
        {
            Control ctrl = Task.Run(() => XamlHelper.LoadControl("test_xamlwriter.xaml")).Result;

            Assert.AreNotEqual(ctrl, null);
            Assert.IsInstanceOfType(ctrl, typeof(UIButton));
        }
    }
}
