﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.UIControls.BaseControls;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Test class for UITreeView related features.
    /// </summary>
    [TestClass]
    public class UITreeViewUnitTests
    {
        /// <summary>
        /// Test node selection.
        /// </summary>
        [TestMethod]
        public void TestIsSelected()
        {
            UITreeView treeView = this.CreateTreeView();

            var n122 = (UITreeNode)treeView.Nodes[0].Nodes[1].Nodes[1];
            var n13 = (UITreeNode)treeView.Nodes[0].Nodes[2];

            n122.IsSelected = true;
            Assert.AreEqual(treeView.SelectedNode, n122);
            Assert.IsTrue(n122.IsSelected);

            n13.IsSelected = true;
            Assert.AreEqual(treeView.SelectedNode, n13);
            Assert.IsTrue(n13.IsSelected);
        }

        /// <summary>
        /// Create a UITreeView with UITreeNodes.
        /// </summary>
        /// <returns>Returns an instance of UITreeView.</returns>
        private UITreeView CreateTreeView()
        {
            /*
             * + n1
             * |
             * |---+ n11
             * |
             * |---+ n12
             * |   |
             * |   |---+ n121
             * |   |
             * |   |---+ n122
             * |   |
             * |   |---+ n123
             * |
             * |---+ n13
             * |
             * + n2
            */

            var treeView = new UITreeView();

            UITreeNode n1;
            UITreeNode n11;
            UITreeNode n12;
            UITreeNode n121;
            UITreeNode n122;
            UITreeNode n123;
            UITreeNode n13;
            UITreeNode n2;

            n1 = new UITreeNode() { Name = "n1" };
            {
                n11 = new UITreeNode() { Name = "n11" };
                n12 = new UITreeNode() { Name = "n12" };
                {
                    n121 = new UITreeNode() { Name = "n121" };
                    n122 = new UITreeNode() { Name = "n122" };
                    n123 = new UITreeNode() { Name = "n123" };
                }

                n13 = new UITreeNode() { Name = "n13" };
            }

            n2 = new UITreeNode() { Name = "n2" };

            n12.Nodes.Add(n121);
            n12.Nodes.Add(n122);
            n12.Nodes.Add(n123);

            n1.Nodes.Add(n11);
            n1.Nodes.Add(n12);
            n1.Nodes.Add(n13);

            treeView.Nodes.Add(n1);
            treeView.Nodes.Add(n2);

            return treeView;
        }
    }
}
