﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Input;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Extensions;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.UIControls.TestTypes;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Class containing unit test related to the UIRadioButton control.
    /// </summary>
    [TestClass]
    public class UIRadioButtonUnitTests
    {
        /// <summary>
        /// Test the Checked property through data binding.
        /// </summary>
        [TestMethod]
        public void TestUIRadioButton01()
        {
            var radio = new UIRadioButton();
            var dataSource = new BooleanViewModel();

            radio.AddBinding("Checked", "Value");

            radio.DataContext = dataSource;

            Assert.AreEqual(radio.Checked, false, "Failed");
            Assert.AreEqual(dataSource.Value, false, "Failed");

            radio.Checked = true;

            Assert.AreEqual(dataSource.Value, true, "Failed");

            dataSource.Value = false;

            Assert.AreEqual(radio.Checked, false, "Failed");
        }

        /// <summary>
        /// Test the IExecutable binding.
        /// </summary>
        [TestMethod]
        public void TestUIRadioButton02()
        {
            var counter = 0;

            var radio = new UIRadioButton();
            radio.OnCheckedChangedExecutable = new AnonymousExecutable(() => counter++);

            radio.Checked = true;

            Assert.AreEqual(1, counter);

            radio.OnCheckedChangedExecutable = null;

            radio.Checked = false;

            Assert.AreEqual(1, counter);
        }
    }
}
