﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using EffectMaker.UIControls;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Layout;
using EffectMaker.UIControls.SpecificControls;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// An extended UIXamlControl for test purpose only.
    /// </summary>
    public class TestXamlControl : UIXamlControl
    {
        /// <summary>
        /// Gets whether the XAML loading test has succeeded or failed.
        /// </summary>
        public bool IsSuccessful { get; private set; }

        /// <summary>
        /// Called when the definition XAML file has been loaded.
        /// </summary>
        /// <param name="rootControl">The root control defined in the XAML file.</param>
        /// <param name="controls">The flattened control list.</param>
        protected override void OnXamlLoaded(
            IControl rootControl,
            IDictionary<string, IControl> controls)
        {
            base.OnXamlLoaded(rootControl, controls);

            if (rootControl.Name != "root")
            {
                return;
            }

            if ((rootControl is UIGroupBox) == false)
            {
                return;
            }

            if (controls.Count != 5)
            {
                return;
            }

            if (controls.ContainsKey("root") == false ||
                (controls["root"] is UIGroupBox) == false)
            {
                return;
            }

            if (controls.ContainsKey("stackPanel1") == false ||
                (controls["stackPanel1"] is StackPanel) == false)
            {
                return;
            }

            for (int i = 1; i <= 3; i++)
            {
                var name = string.Format("btn{0}", i);

                if (controls.ContainsKey(name) == false ||
                    (controls[name] is UIButton) == false)
                {
                    return;
                }
            }

            this.IsSuccessful = true;
        }
    }
}
