﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.UIControls;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Extensions;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// An extended UITreeView for testing purpose only.
    /// </summary>
    public class TestTreeView : UITreeView
    {
        /// <summary>
        /// Initializes the TestTreeView instance.
        /// </summary>
        public TestTreeView()
        {
            this.ItemContainerType = typeof(TestTreeNode);

            this.AddBinding("Text", "Value");
            this.AddBinding("ItemsSource", "Items");
        }
    }
}
