﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Core;
using EffectMaker.Foundation.Primitives;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// An extended PrimitiveBase class for test purpose only.
    /// </summary>
    public class TestPrimitiveBase : PrimitiveBase<int>
    {
        /// <summary>
        /// Gets the number of components.
        /// </summary>
        public override int Count
        {
            get { return 1; }
        }

        /// <summary>
        /// Gets the type of component.
        /// </summary>
        public override ValueTypes ValueType
        {
            get { return ValueTypes.Int; }
        }

        /// <summary>
        /// Sets values to zero.
        /// </summary>
        public override void SetZero()
        {
            this.Values[0] = 0;
        }

        /// <summary>
        /// Sets values to one.
        /// </summary>
        public override void SetOne()
        {
            this.Values[0] = 1;
        }

        /// <summary>
        /// Parse a string into values.
        /// </summary>
        /// <param name="strElement">The string to parse that contains the values.</param>
        /// <param name="value">The value to output.</param>
        /// <returns>Returns true if pasring was successful, false otherwise.</returns>
        protected override bool ParseElement(string strElement, out int value)
        {
            return int.TryParse(strElement, out value);
        }
    }
}
