﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Input;
using EffectMaker.Foundation.Interfaces;
using EffectMaker.UIControls.Input;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Test view model class with executable.
    /// </summary>
    public class TestExecutableViewModel : DummyViewModel
    {
        /// <summary>
        /// Backing field for the Counter property.
        /// </summary>
        private int counter;

        /// <summary>
        /// Initializes the TestExecutableViewModel instance.
        /// </summary>
        public TestExecutableViewModel()
        {
            this.IncrementCounterExecutable = new AnonymousExecutable(this.OnIncrementCounter);
        }

        /// <summary>
        /// Gets the counter.
        /// </summary>
        public int Counter
        {
            get
            {
                return this.counter;
            }

            private set
            {
                this.SetValue(ref this.counter, value);
            }
        }

        /// <summary>
        /// Gets a executable that increment the internal counter when executed.
        /// </summary>
        public IExecutable IncrementCounterExecutable
        {
            get;
            private set;
        }

        /// <summary>
        /// Increment the Counter property.
        /// </summary>
        private void OnIncrementCounter()
        {
            this.Counter++;
        }
    }
}
