﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Interfaces;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Test String to Boolean value converter.
    /// </summary>
    public class StringToBooleanValueConverter : IValueConverter
    {
        /// <summary>
        /// Convert a string to bool.
        /// </summary>
        /// <param name="value">String value to convert.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns 'true' if the value is true,
        /// 'false' is the value is false
        /// or null if the value is not of type string.</returns>
        public object Convert(
            object value,
            Type targetType,
            object parameter)
        {
            var str = value as string;
            if (str == null)
            {
                return null;
            }

            switch (str.ToLowerInvariant())
            {
                case "true": return true;
                case "false": return false;
            }

            return null;
        }

        /// <summary>
        /// Convert a bool to string.
        /// </summary>
        /// <param name="value">Boolean value to convert.</param>
        /// <param name="targetType">The type to convert to.</param>
        /// <param name="parameter">A custom parameter.</param>
        /// <returns>Returns nothing, throws a NotImplementedException exception.</returns>
        public object ConvertBack(
            object value,
            Type targetType,
            object parameter)
        {
            throw new NotImplementedException();
        }
    }
}
