﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.UIControls.Behaviors;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// A behavior that changes the Text property of a control.
    /// </summary>
    public class ChangeTextBehavior : Behavior<Control>
    {
        /// <summary>
        /// Stores the original text of the control in order to restore it.
        /// </summary>
        private string orginialText;

        /// <summary>
        /// Stores the new text to set to the control when attached.
        /// </summary>
        private string newText;

        /// <summary>
        /// Initializes the ChangeTextBehavior instance.
        /// </summary>
        /// <param name="newText">The new text to set to the control.</param>
        public ChangeTextBehavior(string newText)
        {
            if (string.IsNullOrWhiteSpace(newText))
            {
                throw new ArgumentException("newText");
            }

            this.newText = newText;
        }

        /// <summary>
        /// Attaches to the control.
        /// </summary>
        protected override void OnAttached()
        {
            this.orginialText = this.AssociatedObject.Text;
            this.AssociatedObject.Text = this.newText;
        }

        /// <summary>
        /// Detaches from the control.
        /// </summary>
        protected override void OnDetaching()
        {
            this.AssociatedObject.Text = this.orginialText;
        }
    }
}
