﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using EffectMaker.Foundation.Debugging.Profiling;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.Foundation.UnitTests
{
    /// <summary>
    /// Test class for Instrumenation mechanisms.
    /// </summary>
    [TestClass]
    public class InstrumentationUnitTests
    {
        /// <summary>
        /// Test the Step method.
        /// </summary>
        [TestMethod]
        public void Test01()
        {
            IInstrumentation instrument;

            using (instrument = new Instrumentation())
            {
                Thread.Sleep(1000);
                instrument.Step("Wait 1 second");

                Thread.Sleep(3);
                instrument.Step("Wait 3 milliseconds");
            }

            string result = instrument.ToString();
            Console.WriteLine(result);
        }

        /// <summary>
        /// Test the Accumulate method.
        /// </summary>
        [TestMethod]
        public void Test02()
        {
            IInstrumentation instrument;

            using (instrument = new Instrumentation())
            {
                Thread.Sleep(1000);
                instrument.Accumulate("Thread.Sleep method call");

                Thread.Sleep(350);
                instrument.Accumulate("Thread.Sleep method call");
            }

            string result = instrument.ToString();
            Console.WriteLine(result);
        }
    }
}
