﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Utility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.Foundation.UnitTests
{
    /// <summary>
    /// Test class for ColorUtility.
    /// </summary>
    [TestClass]
    public class ColorUtilityTests
    {
        /// <summary>
        /// RGBA と HSVA 間のコンバートテストです。
        /// </summary>
        [TestMethod]
        public void Test01()
        {
            {
                ColorRgba expected = new ColorRgba(2f, 2f, 2f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(2f, 1f, 1f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(100f, 0f, 0.1f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(1.2f, 0.5f, 0.2f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(100.2f, 50.5f, 10.2f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(0f, 0f, 0f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(1f, 0f, 0f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }

            {
                ColorRgba expected = new ColorRgba(1f, 1f, 1f, 1f);
                ColorHsva hsva = ColorUtility.ToColorHsva(expected);
                ColorRgba actual = ColorUtility.ToColorRgba(hsva);
                float delta = 0.0001f;
                Assert.AreEqual(expected.R, actual.R, delta);
                Assert.AreEqual(expected.G, actual.G, delta);
                Assert.AreEqual(expected.B, actual.B, delta);
                Assert.AreEqual(expected.A, actual.A, delta);
            }
        }
    }
}

