﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nw/dev.h>
#include <nw/eft2.h>
#include <nw/eft/eftvw2_FileSystem.h>
#include <nw/eft/eftvw2_String.h>


//------------------------------------------------------------------------------
//  デモ初期化処理
//------------------------------------------------------------------------------
void Demo_Initialize( nw::ut::MemoryAllocator* allocator, nw::eft2::System* effectSystem, nw::eftvw2::ViewerSystem* effectViewerSystem );

//------------------------------------------------------------------------------
//  デモ終了処理
//------------------------------------------------------------------------------
void Demo_Finalize();

//------------------------------------------------------------------------------
//  デモ計算処理
//------------------------------------------------------------------------------
void Demo_ProcCalc();

//------------------------------------------------------------------------------
//  デモ描画処理
//------------------------------------------------------------------------------
void Demo_ProcDraw();
