﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
enum
{
    FILEHEADERSIZE = 14,
    INFOHEADERSIZE = 40
};
#define HEADERSIZE (FILEHEADERSIZE + INFOHEADERSIZE)


typedef struct{
    unsigned char b;
    unsigned char g;
    unsigned char r;
}Rgb;

typedef struct{
    unsigned int height;
    unsigned int width;
    Rgb *data;
}Image;

//書き込みに成功すれば0を失敗すれば1を返す
int Write_Bmp(const char *filename, Image *img);

//Imageを作成し、RGB情報もwidth*height分だけ動的に取得する。
//成功すればポインタを、失敗すればNULLを返す
Image *Create_Image(int width, int height);
//Imageを解法する
void Free_Image(Image *img);


//----------------------------------------
// カレントバッファをBMPとして保存
//----------------------------------------
void SaveCurrentBufferAsBmpFile( f32 width, f32 height, const char* filename, bool linear );
