﻿using System;
using System.Runtime.Serialization;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DevMenuCommandTestNuiShell
{
    [DataContract]
    public class VersionList
    {
        public VersionList()
        {
            FormatVersion = 1;
        }

        [DataMember (Name = "format_version")]
        public UInt32 FormatVersion { get; set; }
        [DataMember (Name = "last_modified")]
        public UInt64 LastModified { get; set; }
        [DataMember (Name = "titles")]
        public TitleObject[] Titles { get; set; }
    }

    [DataContract]
    public class TitleObject
    {
        [DataMember (Name = "id")]
        public string Id { get; set; }

        [DataMember (Name = "version")]
        public UInt32 Version { get; set; }

        [IgnoreDataMember]
        public UInt32? RequiredVersionValue;
        [DataMember (Name = "required_version")]
        public UInt32 RequiredVersion
        {
            get
            {
                return RequiredVersionValue ?? Version;
            }
            set
            {
                RequiredVersionValue = value;
            }
        }
    }
}
