﻿using System;
using System.Collections.Generic;
using System.Threading;
using System.Web.Script.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using DevMenuCommandTest;


namespace DevMenuCommandTestNuiShell
{
    [TestClass]
    public class TestLocalContentDelivery : TestBase
    {
        public override void DoCleanup()
        {
            var command = new DevMenuCommandSystem(this.TestContext);
            command.Execute(new string[] {
                "application uninstall --all",
                "application reset-required-version --all"
            });
            command.ResetAndExecute(new string[]
            {
                // 再起動して不要なコンテンツを削除するため
                ""
            });
        }


        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestGetSystemDeliveryInfo()
        {
            var command = new DevMenuCommandSystem(this.TestContext);
            command.Execute(new string[] {
                "localcontentshare get-system-delivery-info"
            });
            var info = new JavaScriptSerializer().Deserialize<SystemDeliveryInfoForJson>(command.LastOutput);
            Assert.AreEqual(1u, info.systemDeliveryProtocolVersion);
            Assert.AreEqual(1u, info.applicationDeliveryProtocolVersion);
            Assert.AreEqual(1u, info.attributes); // IncludesExFatDriver
            var systemUpdateString = string.Format("{0}\\\\s+{1}\\\\s+SystemUpdate", info.systemUpdateId, info.systemUpdateVersion);

            command.Execute(new string[]
            {
                "systemprogram list"
            },
                systemUpdateString
            );
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestGetApplicationDeliveryInfo()
        {
            var command = new DevMenuCommandSystem(this.TestContext);
            ulong id = 0x0100394000059000;
            var appv0 = m_Maker.MakeApplication(id, requiredSystemVersion: 1);
            var patchv2 = m_Maker.MakePatch(id, version: 2, original: appv0.Path, requiredSystemVersion: 2);

            command.Execute(new string[] {
                "application install " + appv0.Path,
            });
            command.Execute(new string[] {
                string.Format("localcontentshare get-application-delivery-info 0x{0:x16} --patch", id)
            });

            var infoList = new JavaScriptSerializer().Deserialize<List<ApplicationDeliveryInfoForJson>>(command.LastOutput);
            Assert.AreEqual(1, infoList.Count);
            var info = infoList[0];
            Assert.AreEqual(string.Format("0x{0:x16}", id), info.id);
            Assert.AreEqual(0u, info.version);
            Assert.AreEqual(0u, info.requiredVersion);
            Assert.AreEqual(1u, info.requiredSystemVersion);
            Assert.AreEqual(2u, info.attributes); // RequestPatch

            command.Execute(new string[] {
                "application install " + patchv2.Path,
            });
            command.Execute(new string[] {
                string.Format("localcontentshare get-application-delivery-info 0x{0:x16} --patch", id)
            });

            infoList = new JavaScriptSerializer().Deserialize<List<ApplicationDeliveryInfoForJson>>(command.LastOutput);
            Assert.AreEqual(1, infoList.Count);
            info = infoList[0];
            Assert.AreEqual(string.Format("0x{0:x16}", id), info.id);
            Assert.AreEqual(2u << 16, info.version);
            Assert.AreEqual(0u, info.requiredVersion);
            Assert.AreEqual(2u, info.requiredSystemVersion);
            Assert.AreEqual(1342177282u, info.attributes); // RequestPatch | HasPatchRecord | HasPatchEntity

            SuccessLaunchApplication(command, id);

            command.Execute(new string[] {
                string.Format("localcontentshare get-application-delivery-info 0x{0:x16} --patch", id)
            });

            infoList = new JavaScriptSerializer().Deserialize<List<ApplicationDeliveryInfoForJson>>(command.LastOutput);
            Assert.AreEqual(1, infoList.Count);
            info = infoList[0];
            Assert.AreEqual(string.Format("0x{0:x16}", id), info.id);
            Assert.AreEqual(2u << 16, info.version);
            Assert.AreEqual(2u << 16, info.requiredVersion);
            Assert.AreEqual(2u, info.requiredSystemVersion);
            Assert.AreEqual(1342177282u, info.attributes); // RequestPatch | HasPatchRecord | HasPatchEntity

            command.Execute(new string[] {
                string.Format("application delete-entity 0x{0:x16} --patch", id),
            });
            command.Execute(new string[] {
                string.Format("localcontentshare get-application-delivery-info 0x{0:x16} --patch", id)
            });

            infoList = new JavaScriptSerializer().Deserialize<List<ApplicationDeliveryInfoForJson>>(command.LastOutput);
            Assert.AreEqual(1, infoList.Count);
            info = infoList[0];
            Assert.AreEqual(string.Format("0x{0:x16}", id), info.id);
            Assert.AreEqual(2u << 16, info.version);
            Assert.AreEqual(2u << 16, info.requiredVersion);
            // info.version に相当する requiredSystemVersion が取得できないので、 0 が入る
            Assert.AreEqual(0u, info.requiredSystemVersion);
            Assert.AreEqual(1073741826u, info.attributes); // RequestPatch | HasPatchRecord

            command.Execute(new string[] {
                string.Format("application delete-entity 0x{0:x16} --app", id),
            });
            command.Execute(new string[] {
                string.Format("localcontentshare get-application-delivery-info 0x{0:x16} --patch", id)
            });

            infoList = new JavaScriptSerializer().Deserialize<List<ApplicationDeliveryInfoForJson>>(command.LastOutput);
            Assert.AreEqual(1, infoList.Count);
            info = infoList[0];
            Assert.AreEqual(string.Format("0x{0:x16}", id), info.id);
            Assert.AreEqual(2u << 16, info.version);
            Assert.AreEqual(2u << 16, info.requiredVersion);
            Assert.AreEqual(0u, info.requiredSystemVersion);
            Assert.AreEqual(1073741826u, info.attributes); // RequestPatch | HasPatchRecord

            command.FailureExecute(
                string.Format("localcontentshare get-application-delivery-info 0x{0:x16} --app", id),
                string.Format("Unexpected error. result = 0x{0:x16}", 0x00067c10) // ResultInvalidContentDeliveryRequest
            );
        }
    }
}
