﻿using System;
using System.Collections.Generic;
using System.Web.Script.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using DevMenuCommandTest;

namespace DevMenuCommandTestNuiShell
{
    [TestClass]
    public class TestCleanupPlaceHolder : TestBase
    {
        public override void DoCleanup()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            command.Execute(new string[] {
                "sdcard format",
            });
            command.ResetAndExecute(new string[] {
                "application uninstall --all",
            });
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestCleanupOnCancelDownload()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            Assert.IsTrue(command.Execute(new string[] {
                "application uninstall --all",
                "application create-download-task 0x0100394000059000",
            }));
            Assert.IsTrue(command.Execute(new string[] {
                "application create-place-holder -s sdcard",
                "application create-place-holder -s sdcard",
                "application create-place-holder",
                "application create-place-holder",
                "application list-place-holder",
            }));
            var placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);
            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder -s sdcard",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application uninstall --all",
                "application list-place-holder",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder -s sdcard",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestCleanupOnBoot()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            Assert.IsTrue(command.Execute(new string[] {
                "application create-place-holder -s sdcard",
                "application create-place-holder -s sdcard",
                "application create-place-holder",
                "application create-place-holder",
                "application list-place-holder",
            }));
            var placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);
            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder -s sdcard",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);

            // 再起動
            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "application list-place-holder",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder -s sdcard",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);
        }

        [TestMethod]
        [Timeout(300 * 1000)]
        public void TestCleanupOnFactoryReset()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            Assert.IsTrue(command.Execute(new string[] {
                "application create-place-holder",
                "application create-place-holder",
                "application list-place-holder",
            }));
            var placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "factoryreset do",
            }));

            Reboot(command);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);

            // セーブを残して
            Assert.IsTrue(command.Execute(new string[] {
                "application create-place-holder",
                "application create-place-holder",
                "application list-place-holder",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count > 0);

            Assert.IsTrue(command.Execute(new string[] {
                "factoryreset do-without-usersavedata",
            }));

            Reboot(command);

            Assert.IsTrue(command.Execute(new string[] {
                "application list-place-holder",
            }));
            placeHolderList = new JavaScriptSerializer().Deserialize<List<string>>(command.LastOutput);
            Assert.IsTrue(placeHolderList.Count == 0);
        }
    }
}
