﻿using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTestNuiShell
{
    public class ApplicationViewFlag
    {
        public int FlagValue;

        public static readonly int HasRecord                                    = 1 << 0;
        public static readonly int HasMainRecord                                = 1 << 1;
        public static readonly int HasPatchRecord                               = 1 << 2;
        public static readonly int HasAddOnContentRecord                        = 1 << 3;
        public static readonly int HasMainInstallRecord                         = 1 << 4;
        public static readonly int DownLoading                                  = 1 << 5;
        public static readonly int IsGameCard                                   = 1 << 6;
        public static readonly int HasGameCardEntity                            = 1 << 7;
        public static readonly int IsLaunchable                                 = 1 << 8;
        public static readonly int HasAllEntity                                 = 1 << 9;
        public static readonly int HasMainEntity                                = 1 << 10;
        public static readonly int HasAllAddOnContentEntity                     = 1 << 11;
        public static readonly int HasPatchEntity                               = 1 << 12;
        public static readonly int MaybeCorrupted                               = 1 << 13;
        public static readonly int WaitingAocCommit                             = 1 << 14;
        public static readonly int WaitingPatchInstall                          = 1 << 15;
        public static readonly int AutoDeleteDisabled                           = 1 << 16;
        public static readonly int ApplyingDelta                                = 1 << 17;
        public static readonly int WaitingApplicationCommit                     = 1 << 18;
        public static readonly int HasAnyAddOnContentEntity                     = 1 << 19;
        public static readonly int IsCleanupAddOnContentWithNoRightsRecommended = 1 << 20;
        public static readonly int ApplicationViewFlag_IsPreInstalledApplication = 1 << 21;

        public static readonly int MaxFlagCount = 22;

        public static int DefaultFlags          = ApplicationViewFlag.HasRecord
                                                | ApplicationViewFlag.HasAllEntity
                                                | ApplicationViewFlag.HasAllAddOnContentEntity; // 存在しないときにも True になるため

        public static int AllInstalledFlags     = ApplicationViewFlag.HasRecord
                                                | ApplicationViewFlag.HasMainRecord
                                                | ApplicationViewFlag.HasMainInstallRecord
                                                | ApplicationViewFlag.IsLaunchable
                                                | ApplicationViewFlag.HasAllEntity
                                                | ApplicationViewFlag.HasMainEntity
                                                | ApplicationViewFlag.HasAllAddOnContentEntity
                                                | ApplicationViewFlag.HasAddOnContentRecord
                                                | ApplicationViewFlag.HasAllAddOnContentEntity
                                                | ApplicationViewFlag.HasPatchRecord
                                                | ApplicationViewFlag.HasPatchEntity
                                                | ApplicationViewFlag.HasAnyAddOnContentEntity;

        public static int ApplicationFlags      = ApplicationViewFlag.HasMainRecord
                                                | ApplicationViewFlag.HasMainInstallRecord
                                                | ApplicationViewFlag.IsLaunchable
                                                | ApplicationViewFlag.HasMainEntity;

        public static int PatchFlags            = ApplicationViewFlag.HasPatchRecord
                                                | ApplicationViewFlag.HasPatchEntity;

        public static int AocFlags              = ApplicationViewFlag.HasAddOnContentRecord
                                                | ApplicationViewFlag.HasAllAddOnContentEntity
                                                | ApplicationViewFlag.HasAnyAddOnContentEntity;

        public static int GameCardFlags         = ApplicationViewFlag.IsGameCard
                                                | ApplicationViewFlag.HasGameCardEntity;


        public ApplicationViewFlag(int flag)
        {
            FlagValue = flag;
        }


        public static string MakeApplicationViewFlagTestString(ulong id, int innerValue)
        {
            var flag = new ApplicationViewFlag(innerValue);
            return string.Format("0x{0:x16}.* {1} ", id, flag.ToString());
        }

        public ApplicationViewFlag(string line)
        {
            Assert.IsTrue(line.Length == MaxFlagCount);

            for (var i = 0; i < MaxFlagCount; i++)
            {
                Assert.IsTrue(line[i] == '+' || line[i] == '-');
                if (line[i] == '+')
                {
                    FlagValue |= 1 << i;
                }
            }
        }

        public override string ToString()
        {
            string line = "";
            for (var i = 0; i < MaxFlagCount; i++)
            {
                line += (FlagValue & (1 << i)) > 0 ? "\\+" : "\\-";
            }

            return line;
        }

    }
}
