﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Web.Script.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTest
{
    [TestClass]
    public class DevMenuCommandTestLong
    {
        public TestContext TestContext { get; set; }

        [TestMethod]
        public void TestManyAddOnContentSeveralApplication()
        {
            const int AddOnContentCount = 2000;

            var appMaker = new MakeTestApplication(this.TestContext, "Application");
            var aocMaker = new MakeTestApplication(this.TestContext, "AddOnContent");
            var command = new DevMenuCommandSystem(this.TestContext);

            var appList = new ulong[]
            {
                0x0100394000059000,
                0x0100394000069000,
            };

            foreach (var appId in appList)
            {
                appMaker.MakeApplication(appId, 0);
                aocMaker.MakeMultipleAddOnContent(appId, 1, AddOnContentCount);
            }

            Assert.IsTrue(command.Execute(new string[] {
                "application uninstall --all",
                "ticket delete-all",
                "application install " + appMaker.GetOutputDirectory() + " --all",
                "addoncontent install " + aocMaker.GetOutputDirectory() + " --all",
            }));

            Assert.IsTrue(command.Execute(new string[] {
                "application list-view",
            }));

            var viewList = new JavaScriptSerializer().Deserialize<List<Dictionary<string, object>>>(command.LastOutput);
            foreach (var view in viewList)
            {
                Assert.IsTrue((bool)view["hasRecord"]);
                Assert.IsTrue((bool)view["hasMainRecord"]);
                Assert.IsFalse((bool)view["hasPatchRecord"]);
                Assert.IsTrue((bool)view["hasAddOnContentRecord"]);
                Assert.IsTrue((bool)view["hasMainInstallRecord"]);
                Assert.IsTrue((bool)view["isLaunchable"]);
                Assert.IsTrue((bool)view["hasAllEntity"]);
                Assert.IsTrue((bool)view["hasMainEntity"]);
                Assert.IsTrue((bool)view["hasAllAddOnContentEntity"]);
                Assert.IsFalse((bool)view["hasPatchEntity"]);
            }

            foreach (var app in appList)
            {
                Assert.IsTrue(command.Execute(new string[] {
                    String.Format("application list-record {0:x16}", app),
                }));

                var recordList = new JavaScriptSerializer().Deserialize<List<Dictionary<string, object>>>(command.LastOutput);
                Assert.IsTrue(recordList.Exists(dic => (string)dic["id"] == "0x" + app.ToString("x16")));
                for(int i = 0; i < AddOnContentCount; i++)
                {
                    Assert.IsTrue(recordList.Exists(dic => (string)dic["id"] == "0x" + (app + 0x1001 + (ulong)i).ToString("x16")));
                }
            }

            Assert.IsTrue(command.Execute(new string[] {
                "application uninstall --all",
                "ticket delete-all",
            }));
        }
    }
}
