﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTest
{
    public class ExFatRecovery : IDisposable
    {
        private const string BootImagePackagePathInRepository = "Programs/Eris/Outputs/NX-NXFP2-a64/SystemData/BootImagePackageExFat-K5-Unsigned/Develop/BootImagePackageExFat-K5-Unsigned.nsp";
        private DevMenuCommandSystem m_Command;
        private string m_BootImagePackagePath;

        public ExFatRecovery(DevMenuCommandSystem command, TestContext context)
        {
            m_Command = command;
            m_BootImagePackagePath = Path.Combine(new TestUtility.TestPath(context).GetSigloRoot(), BootImagePackagePathInRepository);
        }

        public void Dispose()
        {
            m_Command.Execute(new string[]
            {
                "systemprogram install " + m_BootImagePackagePath,
                "systemupdate update-bootimages"
            });

            // 強制再起動
            m_Command.ResetAndExecute(new string[] { "" });
        }
    }
}
