﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTest
{
    public class ControlTarget
    {
        private string m_ControlTargetPath;

        public ControlTarget(TestContext context)
        {
            m_ControlTargetPath = System.IO.Path.Combine(new TestUtility.TestPath(context).GetSigloRoot(), "Tools/CommandLineTools/ControlTarget.exe");
        }

        public Tuple<bool, StringBuilder, StringBuilder> Execute(string args)
        {
            using (var process = new Process())
            {
                var outputs = ProcessManager.SetupProcess(process, m_ControlTargetPath, args);
                ProcessManager.RunAndWaitProcess(process);

                return new Tuple<bool, StringBuilder, StringBuilder>(process.ExitCode == 0, outputs.Item1, outputs.Item2);
            }
        }

        public string[] ListTarget()
        {
            var outputs = Execute("list-target");
            if (!outputs.Item1)
            {
                return null;
            }
            var stdout = outputs.Item2.ToString();
            List<string> targetList = new List<string>();
            foreach (var line in stdout.Split(new string[] { Environment.NewLine }, StringSplitOptions.None))
            {
                Regex regex = new Regex(@"(\w+)\s+(\w+)");

                var match = regex.Match(line);
                if (match.Success)
                {
                    targetList.Add(match.Groups[1].Value);
                }
            }
            return targetList.ToArray();
        }
    }
}
