﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTest
{
    public class AuthoringTool
    {
        public string KeyConfigFilePath { get; private set; }
        private string m_AuthoringToolPath;

        public AuthoringTool(TestContext context)
        {
            m_AuthoringToolPath = System.IO.Path.Combine(new TestUtility.TestPath(context).GetSigloRoot(), "Tools/CommandLineTools/AuthoringTool/AuthoringTool.exe");
            KeyConfigFilePath = System.IO.Path.Combine(new TestUtility.TestPath(context).GetSigloRoot(), "Tools/CommandLineTools/AuthoringTool/AuthoringTool.repository.keyconfig.xml");
        }

        public Tuple<bool, StringBuilder, StringBuilder> Execute(string args)
        {
            using (var process = new Process())
            {
                var outputs = ProcessManager.SetupProcess(process, m_AuthoringToolPath, args);
                ProcessManager.RunAndWaitProcess(process);

                return new Tuple<bool, StringBuilder, StringBuilder>(process.ExitCode == 0, outputs.Item1, outputs.Item2);
            }
        }


    }
}
