﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CradleSwitchTest
{
    [TestClass]
    public class ExcecutionTest
    {
        public TestContext TestContext { get; set; }

        private static string targetName = string.Empty;

        [ClassInitialize]
        public static void TestClassInitialize(TestContext context)
        {
            targetName = (string)context.Properties["TargetName"];
        }

        private bool ExecuteRunOnTarget(string option, string ncaPath, string args)
        {
            Console.WriteLine("RunOnTarget start.");

            using (var process = new Process())
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                var standardOutput = new StringBuilder();
                var standardError = new StringBuilder();

                process.StartInfo.FileName = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\RunOnTarget.exe";
                process.StartInfo.Arguments = " -t " + targetName +
                                              " --failure-timeout 60 " +
                                              " -v " +
                                              option +
                                              " " +
                                              ncaPath +
                                              " -- " +
                                              args;
                process.StartInfo.CreateNoWindow = true;
                process.StartInfo.UseShellExecute = false;
                process.StartInfo.RedirectStandardOutput = true;
                process.StartInfo.RedirectStandardError = true;
                process.StartInfo.StandardOutputEncoding = System.Text.Encoding.UTF8;
                process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardOutput.AppendLine(e.Data);
                };
                process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardError.AppendLine(e.Data);
                };

                Console.WriteLine("process start.");
                Console.WriteLine(String.Format("FileName={0}, Arguments={1}", process.StartInfo.FileName, process.StartInfo.Arguments));
                process.Start();
                process.BeginOutputReadLine();
                process.BeginErrorReadLine();
                Console.WriteLine("process wait for exit.");
                process.WaitForExit();

                Console.WriteLine(String.Format("Standard Output: {0}", standardOutput.ToString()));
                Console.WriteLine(String.Format("Standard Error: {0}", standardError.ToString()));

                return process.ExitCode == 0;
            }
        }

        private bool ExecuteControlTarget(string subCommand)
        {
            Console.WriteLine("ControlTarget start.");

            using (var process = new Process())
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                var standardOutput = new StringBuilder();
                var standardError = new StringBuilder();

                process.StartInfo.FileName = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\ControlTarget.exe";
                process.StartInfo.Arguments = subCommand + " -t " + targetName;
                process.StartInfo.CreateNoWindow = true;
                process.StartInfo.UseShellExecute = false;
                process.StartInfo.RedirectStandardOutput = true;
                process.StartInfo.RedirectStandardError = true;
                process.StartInfo.StandardOutputEncoding = System.Text.Encoding.UTF8;
                process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardOutput.AppendLine(e.Data);
                };
                process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
                {
                    standardError.AppendLine(e.Data);
                };

                Console.WriteLine("process start.");
                Console.WriteLine(String.Format("FileName={0}, Arguments={1}", process.StartInfo.FileName, process.StartInfo.Arguments));
                process.Start();
                process.BeginOutputReadLine();
                process.BeginErrorReadLine();
                Console.WriteLine("process wait for exit.");
                process.WaitForExit();

                Console.WriteLine(String.Format("Standard Output: {0}", standardOutput.ToString()));
                Console.WriteLine(String.Format("Standard Error: {0}", standardError.ToString()));

                return process.ExitCode == 0;
            }
        }

        [TestMethod]
        [Timeout(100 * 1000)]
        public void TestOperationMode()
        {
            Console.WriteLine("TestOperationMode start.");

            const int TEST_LOOP = 10;
            var testPath = new TestUtility.TestPath(this.TestContext);
            for (int i = 0; i < TEST_LOOP; i++)
            {
                ExecuteControlTarget("enable-cradle");
                Assert.IsTrue(ExecuteRunOnTarget("",
                    testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\testOmm_Oe\\Develop\\testOmm_Oe.nsp",
                    "console"));

                ExecuteControlTarget("disable-cradle");
                Assert.IsTrue(ExecuteRunOnTarget("",
                    testPath.GetSigloRoot() + "\\Tests\\Outputs\\NX-NXFP2-a64\\Tests\\testOmm_Oe\\Develop\\testOmm_Oe.nsp",
                    "handheld"));
            }

            ExecuteControlTarget("enable-cradle");
        }
    }
}
