﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// 波括弧の規約チェックに使用するソースファイルです。

class Sample1
{
public:

    Sample1()
    {
        m_Count = 0;
    }

    Sample1(int n)
      : m_Count(n)
    {
    }

    ~Sample1()
    {
    }

    void Func()
    {
    }

    template <typename T>
    void TemplateFunc()
    {
    }

private:

    int m_Count;
};

struct Sample2
{
public:

    Sample2() { }

    Sample2(int n) : m_Count(n) { }

    ~Sample2() { }

    void Func() { }

    template <typename T>
    void TemplateFunc() { }

private:

    int m_Count;
};

class Sample3
{
public:

    Sample3() { m_Count = 0; }             //:) BAD

    Sample3(int n) : m_Count(n) { ++n; }   //:) BAD

    ~Sample3() { ++m_Count; }              //:) BAD

    void Func() { ++m_Count; }             //:) BAD

    template <typename T>
    void TemplateFunc() { ++m_Count; }     //:) BAD

private:

    int m_Count;
};

struct Sample4
{
public:

    Sample4() {                            //:) BAD
        m_Count = 0;
    }

    Sample4(int n) : m_Count(n) {          //:) BAD
        ++n;
    }

    ~Sample4() {                           //:) BAD
        ++m_Count;
    }

    void Func() {                          //:) BAD
        ++m_Count;
    }

    template <typename T>
    void TemplateFunc() {                  //:) BAD
        ++m_Count;
    }

private:

    int m_Count;
};

class Sample5
{
public:

    Sample5()
    { m_Count = 0;                         //:) BAD
    }

    Sample5(int n) : m_Count(n)
    { ++n;                                 //:) BAD
    }

    ~Sample5()
    { ++m_Count;                           //:) BAD
    }

    void Func()
    { ++m_Count;                           //:) BAD
    }

    template <typename T>
    void TemplateFunc()
    { ++m_Count;                           //:) BAD
    }

private:

    int m_Count;
};

struct Sample6
{
public:

    Sample6()
    {
        m_Count = 0;}                      //:) BAD

    Sample6(int n) : m_Count(n)
    {
        ++n;}                              //:) BAD

    ~Sample6()
    {
        ++m_Count;}                        //:) BAD

    void Func()
    {
        ++m_Count;}                        //:) BAD

    template <typename T>
    void TemplateFunc()
    {
        ++m_Count;}                        //:) BAD

private:

    int m_Count;
};
