﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using PushChecker;
using System;
using System.Linq;

namespace PushCheckerTest
{
    [TestClass]
    public class RefCasingConflictDetectorTest
    {
        [TestMethod]
        public void CanDetectConflict()
        {
            var remoteRefs = new[]
            {
                "feature/A",
                "feature/Aa",
                "personal/A/A",
                "personal/A/Aa",
            };

            var sut = new RefCasingConflictDetector(remoteRefs);

            // 別の名前ならOK
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("feature/B"));

            // casing が同じならOK
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("feature/A"));
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("feature/Aa"));

            // パスの途中の casing が異なるので NG
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateConflict("feature/A"), sut.Detect("Feature/Aa"));

            // パスの最後の casing が異なるので NG
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateConflict("feature/Aa"), sut.Detect("feature/aa"));

            // 3要素の場合
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("personal/B/a"));
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("personal/A/B"));

            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("personal/A/A"));
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateNoConflict(), sut.Detect("personal/A/Aa"));

            Assert.AreEqual(RefCasingConflictDetectorResult.CreateConflict("personal/A/A"), sut.Detect("Personal/A/Aa"));
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateConflict("personal/A/A"), sut.Detect("personal/a/Aa"));
            Assert.AreEqual(RefCasingConflictDetectorResult.CreateConflict("personal/A/Aa"), sut.Detect("personal/A/aa"));
        }
    }
}
