﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CommitLogChecker;

namespace CommitLogCheckerTest
{
    [TestClass]
    public class CommitLogConverterTest
    {
        [TestMethod]
        public void TestReplaceCommitLog()
        {
            List<string> jiraKeys = new List<string> { "JIRAKEY1", "JIRAKEY2" };

            {
                var commitLogConverter = new CommitLogConverter("feature/JIRAKEY1-1234_BranchName", jiraKeys);
                Assert.AreEqual(
                    @"(JIRAKEY1-1234)

* JIRAKEY1-1234",
                    commitLogConverter.ReplaceJiraKeySubstitute(@"($(JIRA-KEY))

* $(JIRA-KEY)"));

            }

            {
                // ブランチ名が正しくない
                var commitLogConverter = new CommitLogConverter("feature/BADJIRA-1234_BranchName", jiraKeys);
                Assert.AreEqual(
                    @"($(JIRA-KEY))

* $(JIRA-KEY)",
                    commitLogConverter.ReplaceJiraKeySubstitute(@"($(JIRA-KEY))

* $(JIRA-KEY)"));
            }
        }
    }
}
