﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CodingCheckerUtilTest
{
    internal static class TestUtils
    {
        /// <summary>
        /// 環境変数 SIGLO_GIT_PATH またはレジストリから git.exe のパスを取得します。
        /// </summary>
        /// <returns></returns>
        public static string GetGitExecutablePath()
        {
            string relativePathToKey = @"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Git_is1";
            string valueName = "InstallLocation";
            string gitDirectory =
                Environment.GetEnvironmentVariable("SIGLO_GIT_PATH")
                ?? GetValueFromRegistryKey(RegistryHive.LocalMachine, RegistryView.Registry64, relativePathToKey, valueName) as string
                ?? GetValueFromRegistryKey(RegistryHive.CurrentUser, RegistryView.Registry64, relativePathToKey, valueName) as string
                ?? GetValueFromRegistryKey(RegistryHive.LocalMachine, RegistryView.Registry32, relativePathToKey, valueName) as string
                ?? GetValueFromRegistryKey(RegistryHive.CurrentUser, RegistryView.Registry32, relativePathToKey, valueName) as string;

            if (gitDirectory == null)
            {
                return null;
            }

            return Path.Combine(gitDirectory, "cmd", "git.exe");
        }

        private static object GetValueFromRegistryKey(RegistryHive hive, RegistryView view, string subKeyName, string valueName)
        {
            using (var baseKey = RegistryKey.OpenBaseKey(hive, view))
            {
                using (var subKey = baseKey?.OpenSubKey(subKeyName))
                {
                    return subKey?.GetValue(valueName);
                }
            }
        }
    }
}
