﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using CodingCheckerUtil;
using System;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CodingCheckerUtilTest
{
    [TestClass]
    public class GitUtilTest
    {
        [TestMethod]
        public void CanParseLsRemoteOutput()
        {
            var s =
                "3e006239eacac7201786056d4183aa00b79bcd47\trefs/heads/feature/A\n" +
                "3e2b067da87472ad7db2620016d13fcfad9028e4\trefs/heads/feature/B\n" +
                "\n";

            var expected = new[]
            {
                new RefInfo("refs/heads/feature/A", "3e006239eacac7201786056d4183aa00b79bcd47"),
                new RefInfo("refs/heads/feature/B", "3e2b067da87472ad7db2620016d13fcfad9028e4"),
            };

            CollectionAssert.AreEqual(expected, GitUtil.ParseLsRemoteOutput(s).ToArray());
        }

        [TestMethod]
        public void UnquoteTest()
        {
            Assert.AreEqual("あいうえお", GitUtil.Unquote(@"""\343\201\202\343\201\204\343\201\206\343\201\210\343\201\212"""));
            Assert.AreEqual("あかさたな", GitUtil.Unquote("あかさたな"));
            Assert.AreEqual("abcdef", GitUtil.Unquote("abcdef"));

            // '"' で囲まれていない
            Assert.AreNotEqual("あいうえお", GitUtil.Unquote(@"\343\201\202\343\201\204\343\201\206\343\201\210\343\201\212"));
            // エスケープされていない
            Assert.AreNotEqual("あいうえお", GitUtil.Unquote(@"""343201202343201204343201206343201210343201212"""));
        }
    }
}
